/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockStateModelLoader.class})
public abstract class BlockStateModelMixin {
    private static final StateDefinition<Block, BlockState> BACKPACK_FAKE_DEFINITION = new StateDefinition.Builder((Object)Blocks.AIR).add(new Property[]{IntegerProperty.create((String)"fullness", (int)0, (int)10)}).create(Block::defaultBlockState, BlockState::new);

    @Shadow
    protected abstract void loadBlockStateDefinitions(ResourceLocation var1, StateDefinition<Block, BlockState> var2);

    @Inject(method={"loadAllBlockStates"}, at={@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V")})
    private void loadBackpackStates(CallbackInfo ci) {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        Map resourceMap = resourceManager.listResources("blockstates/backpack", resource -> resource.getPath().endsWith(".json"));
        for (ResourceLocation resourceLocation : resourceMap.keySet()) {
            ResourceLocation location = resourceLocation.withPath(path -> path.replaceAll("blockstates/", "").replaceAll(".json", ""));
            this.loadBlockStateDefinitions(location, BACKPACK_FAKE_DEFINITION);
        }
    }
}

