/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.client;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.container.BackSlot;
import com.beansgalaxy.backpacks.container.UtilityContainer;
import com.beansgalaxy.backpacks.container.UtilitySlot;
import com.beansgalaxy.backpacks.traits.Traits;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Shadow
    private static CreativeModeTab selectedTab;
    private static final ResourceLocation LARGE_SLOT;
    private static final ResourceLocation SMALL_SLOT;

    public CreativeInventoryMixin(CreativeModeInventoryScreen.ItemPickerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    @Inject(method={"hasClickedOutside"}, cancellable=true, at={@At(value="HEAD")})
    private void hasClickedShortSlot(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.hoveredSlot != null) {
            cir.setReturnValue((Object)false);
        }
    }

    protected void renderSlot(GuiGraphics gui, Slot slot) {
        if (slot instanceof BackSlot) {
            gui.blitSprite(LARGE_SLOT, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 18, 18);
        } else if (slot instanceof UtilitySlot) {
            gui.blitSprite(SMALL_SLOT, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 18, 18);
        }
        super.renderSlot(gui, slot);
    }

    @Inject(method={"renderBg"}, at={@At(value="TAIL")})
    private void backpacks_renderBg(GuiGraphics gui, float pPartialTick, int pMouseX, int pMouseY, CallbackInfo ci) {
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY) {
            gui.blitSprite(LARGE_SLOT, this.leftPos + 127 - 1, this.topPos + 20 - 1, 18, 18);
            UtilityContainer utilities = UtilityContainer.get((Player)this.minecraft.player);
            for (byte b = 0; b < utilities.size; b = (byte)(b + 1)) {
                gui.blitSprite(SMALL_SLOT, this.leftPos - 58 + 16, this.topPos + b * 18 - 1, 18, 18);
            }
        }
    }

    @Inject(method={"selectTab"}, at={@At(value="FIELD", shift=At.Shift.BEFORE, ordinal=0, target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;destroyItemSlot:Lnet/minecraft/world/inventory/Slot;")})
    private void addBackSlot(CreativeModeTab pTab, CallbackInfo ci) {
        InventoryMenu abstractcontainermenu = this.minecraft.player.inventoryMenu;
        NonNullList slots = abstractcontainermenu.slots;
        block4: for (int i = 0; i < slots.size(); ++i) {
            Slot slot;
            Slot slot2 = (Slot)slots.get(i);
            Objects.requireNonNull(slot2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BackSlot.class, UtilitySlot.class}, (Object)slot, n)) {
                case 0: {
                    BackSlot backSlot = (BackSlot)slot;
                    CreativeModeInventoryScreen.SlotWrapper wrapped = new CreativeModeInventoryScreen.SlotWrapper((Slot)backSlot, backSlot.index, 127, 20);
                    this.backpacks_setOrAdd(i, wrapped);
                    continue block4;
                }
                case 1: {
                    UtilitySlot utilSlot = (UtilitySlot)slot;
                    CreativeModeInventoryScreen.SlotWrapper wrapped = new CreativeModeInventoryScreen.SlotWrapper((Slot)utilSlot, utilSlot.index, -41, utilSlot.getContainerSlot() * 18);
                    this.backpacks_setOrAdd(i, wrapped);
                    continue block4;
                }
            }
        }
    }

    @Unique
    private void backpacks_setOrAdd(int i, CreativeModeInventoryScreen.SlotWrapper wrapped) {
        if (i < ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).slots.size()) {
            ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).slots.set(i, (Object)wrapped);
        } else {
            ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).slots.add((Object)wrapped);
        }
    }

    @ModifyExpressionValue(method={"slotClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;mayPickup(Lnet/minecraft/world/entity/player/Player;)Z")})
    private boolean backpacks_passMayPickup(boolean original) {
        if (this.hoveredSlot == null) {
            return original;
        }
        ItemStack backpack = this.hoveredSlot.getItem();
        if (Traits.get(backpack).isEmpty()) {
            return original;
        }
        return true;
    }

    @Inject(method={"mouseScrolled"}, cancellable=true, at={@At(value="HEAD")})
    private void backpacks_creativeMouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY, CallbackInfoReturnable<Boolean> cir) {
        int containerId;
        ClientLevel level;
        ItemStack stack;
        if (selectedTab.getType() == CreativeModeTab.Type.INVENTORY && this.hoveredSlot != null && CommonClient.scrollTraits((Player)this.minecraft.player, stack = this.hoveredSlot.getItem(), (Level)(level = this.minecraft.level), containerId = ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).containerId, Mth.floor((double)(pScrollY + 0.5)), this.hoveredSlot)) {
            cir.setReturnValue((Object)true);
        }
    }

    static {
        LARGE_SLOT = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"slots/creative_large");
        SMALL_SLOT = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"slots/creative_small");
    }
}

