/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.client;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.MinecraftAccessor;
import com.beansgalaxy.backpacks.client.KeyPress;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.OptionalInt;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements MinecraftAccessor {
    @Shadow
    static Minecraft instance;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    public ClientLevel level;
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    private int rightClickDelay;
    @Shadow
    @Final
    private DeltaTracker.Timer timer;
    @Shadow
    private volatile boolean pause;
    @Unique
    public final EnderStorage beans_Backpacks_2$enderStorage = new EnderStorage();

    @Shadow
    public abstract DeltaTracker getTimer();

    @Override
    public EnderStorage beans_Backpacks_2$getEnder() {
        return this.beans_Backpacks_2$enderStorage;
    }

    @Inject(method={"startUseItem"}, cancellable=true, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;rightClickDelay:I")})
    private void hotkeyUseItemOn(CallbackInfo ci) {
        boolean isBlockHit = HitResult.Type.BLOCK.equals((Object)MinecraftMixin.instance.hitResult.getType());
        if (!isBlockHit || !BackData.get((Player)this.player).isActionKeyDown()) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)MinecraftMixin.instance.hitResult;
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (!MinecraftMixin.instance.level.getWorldBorder().isWithinBounds(blockPos)) {
            return;
        }
        KeyPress keyPress = KeyPress.INSTANCE;
        LocalPlayer player = MinecraftMixin.instance.player;
        if (keyPress.ACTION_KEY.isUnbound()) {
            OptionalInt callback = keyPress.loadCoyoteClick(player, blockHitResult);
            if (callback.isPresent()) {
                this.rightClickDelay = callback.getAsInt();
                ci.cancel();
            }
        } else if (KeyPress.placeBackpack((Player)player, blockHitResult) || keyPress.pickUpThru(player)) {
            ci.cancel();
        }
    }

    @Inject(method={"startUseItem"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/InteractionResult;shouldSwing()Z")})
    private void tryCoyoteClick(CallbackInfo ci, @Local(ordinal=1) InteractionResult result) {
        KeyPress.INSTANCE.cancelCoyoteClick();
    }

    @Inject(method={"handleKeybinds"}, at={@At(value="TAIL")})
    private void handleBackpackKeybinds(CallbackInfo ci) {
        CommonClient.handleKeyBinds(this.player, this.hitResult);
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V")})
    private void runTickTest(boolean pRenderLevel, CallbackInfo ci) {
        if (this.player != null && !this.pause) {
            DeltaTracker tracker = this.getTimer();
            KeyPress.INSTANCE.tick(instance, this.player, tracker);
        }
    }

    @Inject(method={"pickBlock"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, at={@At(value="JUMP", opcode=159, ordinal=0)})
    private void pickFromBackpack(CallbackInfo ci, @Local int i, @Local ItemStack itemstack, @Local Inventory inventory) {
        if (i != -1) {
            return;
        }
        BackpackTraits.runIfEquipped((Player)this.player, (traits, slot) -> {
            traits.pickBlockClient((Player)this.player, (EquipmentSlot)slot, inventory, itemstack, ci);
            return ci.isCancelled();
        });
    }
}

