/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedPermutations.class})
public class PalettedPermutationsMixin {
    @Mutable
    @Shadow
    private List<ResourceLocation> textures;
    @Shadow
    private Map<String, ResourceLocation> permutations;
    @Unique
    private static final ResourceLocation BACKPACK_TRIMS = ResourceLocation.withDefaultNamespace((String)"beansbackpacks/trims");

    @Inject(method={"run"}, at={@At(value="HEAD")})
    public void injectBackpackTrims(ResourceManager manager, SpriteSource.Output output, CallbackInfo ci) {
        if (this.textures.stream().anyMatch(in -> in.equals((Object)BACKPACK_TRIMS))) {
            Set resourceLocations = manager.listResources("textures/trims/backpacks", in -> in.getPath().endsWith(".png")).keySet();
            NonNullList newLocations = NonNullList.create();
            resourceLocations.forEach(in -> newLocations.add((Object)in.withPath(path -> path.replace("textures/", "").replace(".png", ""))));
            newLocations.addAll(this.textures);
            newLocations.remove((Object)BACKPACK_TRIMS);
            this.textures = newLocations.stream().toList();
            this.permutations = new HashMap<String, ResourceLocation>(this.permutations);
        }
    }
}

