/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.client;

import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import java.util.Iterator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingScreen.class})
public class SmithingScreenMixin {
    @Shadow
    @Nullable
    private ArmorStand armorStandPreview;
    @Unique
    float beans_Backpacks_3$progress = 0.0f;
    @Unique
    float beans_Backpacks_3$yRotO = -150.0f;
    @Unique
    float beans_Backpacks_3$yRot = -150.0f;

    @Inject(method={"updateArmorStandPreview"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;")})
    private void backpackUpdateArmorStandPreview(ItemStack pStack, CallbackInfo ci) {
        BackpackTraits traits = BackpackTraits.get(pStack);
        if (traits == null) {
            return;
        }
        Iterator<EquipmentSlot> iterator = traits.slots().getValues().iterator();
        if (iterator.hasNext()) {
            EquipmentSlot slot = iterator.next();
            this.armorStandPreview.setItemSlot(slot, pStack);
            ci.cancel();
            return;
        }
    }

    @Inject(method={"containerTick"}, at={@At(value="TAIL")})
    private void backpackCalculateArmorStandRot(CallbackInfo ci) {
        float y = this.beans_Backpacks_3$progress;
        double newProgress = y == 0.0f ? 0.0 : (y == 1.0f ? 1.0 : ((double)y < 0.5 ? Math.pow(2.0, 20.0f * y - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * y + 10.0f)) / 2.0));
        this.beans_Backpacks_3$yRotO = this.beans_Backpacks_3$yRot;
        this.beans_Backpacks_3$yRot = (float)newProgress * 180.0f - 150.0f;
    }

    @Inject(method={"renderBg"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;renderEntityInInventory(Lnet/minecraft/client/gui/GuiGraphics;FFFLorg/joml/Vector3f;Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void backpackSpinArmorStandPreview(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, CallbackInfo ci) {
        ItemStack backSlot = this.armorStandPreview.getItemBySlot(EquipmentSlot.BODY);
        if (!backSlot.isEmpty()) {
            if (this.beans_Backpacks_3$progress < 1.0f) {
                this.beans_Backpacks_3$progress += 0.05f;
            }
        } else if (this.beans_Backpacks_3$progress > 0.0f) {
            this.beans_Backpacks_3$progress -= 0.05f;
        }
        this.armorStandPreview.yBodyRot = Mth.lerp((float)pPartialTick, (float)this.beans_Backpacks_3$yRotO, (float)this.beans_Backpacks_3$yRot);
    }
}

