/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.ItemStorageTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractMenuMixin {
    @Shadow
    public abstract Slot getSlot(int var1);

    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void hotKeyPress(int index, int button, ClickType actionType, Player player, CallbackInfo ci) {
        if (index < 0) {
            return;
        }
        boolean menuKeyDown = BackData.get(player).isMenuKeyDown();
        Slot slot = this.getSlot(index);
        ItemStack stack = slot.getItem();
        if (ClickType.THROW.equals((Object)actionType)) {
            ItemStorageTraits.runIfPresent(stack, trait -> trait.hotkeyThrow(slot, ComponentHolder.of(stack), button, player, menuKeyDown, ci), () -> EnderTraits.get(stack).ifPresent(enderTraits -> enderTraits.getTrait().ifPresent(traits -> {
                if (traits instanceof ItemStorageTraits) {
                    ItemStorageTraits storageTraits = (ItemStorageTraits)traits;
                    storageTraits.hotkeyThrow(slot, (ComponentHolder)enderTraits, button, player, menuKeyDown, ci);
                }
            })));
            return;
        }
        if (menuKeyDown) {
            BackpackTraits.runIfEquipped(player, (trait, equipmentSlot) -> {
                trait.hotkeyUse(slot, (EquipmentSlot)equipmentSlot, button, actionType, player, ci);
                return ci.isCancelled();
            });
        }
    }
}

