/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AllayAi.class})
public class AllayAiMixin {
    @Inject(method={"makeBrain"}, at={@At(value="HEAD")})
    private static void backpackMakeBrain(Brain<Allay> pBrain, CallbackInfoReturnable<Brain<?>> cir) {
        OneShot itemPickup = BehaviorBuilder.create(brain -> brain.group((App)brain.registered(MemoryModuleType.LOOK_TARGET), (App)brain.registered(MemoryModuleType.WALK_TARGET), (App)brain.present(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), (App)brain.registered(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS), (App)brain.present(CommonClass.BACKPACK_OWNER_MEMORY.get())).apply((Applicative)brain, (look_target, walk_target, item, cooldown, owner) -> (level, allay, seed) -> {
            ItemEntity itementity = (ItemEntity)brain.get(item);
            if (!level.getWorldBorder().isWithinBounds(itementity.getBoundingBox())) {
                return false;
            }
            if (brain.tryGet(cooldown).isPresent()) {
                return false;
            }
            if (!itementity.closerThan((Entity)allay, 16.0, 32.0)) {
                return false;
            }
            UUID uuid = (UUID)brain.get(owner);
            Player player = level.getPlayerByUUID(uuid);
            if (player != null) {
                float yaw = player.getXRot();
                Vector3f step = yaw < -60.0f ? new Vector3f(0.0f) : (yaw > 60.0f ? new Vector3f(0.0f, -4.0f, 0.0f) : player.getDirection().step().mul(2.0f));
                Vec3 newPos = player.position().add((double)step.x, (double)step.y, (double)step.z);
                if (itementity.position().closerThan((Position)newPos, 6.0)) {
                    return false;
                }
            }
            EntityTracker target = new EntityTracker((Entity)itementity, true);
            WalkTarget walktarget = new WalkTarget((PositionTracker)target, 2.0f, 0);
            look_target.set((Object)target);
            walk_target.set((Object)walktarget);
            return true;
        }));
        BehaviorControl catchupToPlayer = StayCloseToTarget.create(entity -> {
            ServerLevel serverLevel;
            Player player;
            Level patt0$temp = entity.level();
            if (patt0$temp instanceof ServerLevel && (player = AllayAiMixin.getPlayer(serverLevel = (ServerLevel)patt0$temp, (Brain<? extends LivingEntity>)entity.getBrain())) != null) {
                return Optional.of(new EntityTracker((Entity)player, true));
            }
            return Optional.empty();
        }, entity -> !entity.getItemBySlot(EquipmentSlot.BODY).isEmpty() && !entity.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM), (int)8, (int)5, (float)1.65f);
        OneShot<Allay> wanderNearTarget = AllayAiMixin.beans_Backpacks_3$createWanderNearTarget();
        pBrain.addActivityWithConditions(CommonClass.CHESTER_ACTIVITY.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)itemPickup), (Object)Pair.of((Object)1, (Object)catchupToPlayer), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of(wanderNearTarget, (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create(entity -> {
            EntityType type = entity.getType();
            return type == EntityType.PLAYER || type == EntityType.ALLAY;
        }, (float)8.0f), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create(entity -> {
            EntityType type = entity.getType();
            return type == EntityType.GLOW_ITEM_FRAME || type == EntityType.ITEM_FRAME || type == CommonClass.BACKPACK_ENTITY.get();
        }, (float)4.0f), (Object)2), (Object)Pair.of((Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(20, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(CommonClass.BACKPACK_OWNER_MEMORY.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Inject(method={"updateActivity"}, cancellable=true, at={@At(value="HEAD")})
    private static void backpacks_updateActivity(Allay pAllay, CallbackInfo ci) {
        Brain brain = pAllay.getBrain();
        if (brain.checkMemory(CommonClass.BACKPACK_OWNER_MEMORY.get(), MemoryStatus.VALUE_PRESENT)) {
            brain.setActiveActivityIfPossible(CommonClass.CHESTER_ACTIVITY.get());
            ci.cancel();
        }
    }

    @Unique
    private static OneShot<Allay> beans_Backpacks_3$createWanderNearTarget() {
        return BehaviorBuilder.create(in -> in.group((App)in.registered(MemoryModuleType.LOOK_TARGET), (App)in.registered(MemoryModuleType.WALK_TARGET)).apply((Applicative)in, (look, walk) -> (serverLevel, allay, l) -> {
            Vec3 targetPos;
            Vec3 center;
            Brain brain = allay.getBrain();
            Optional memory = brain.getMemory(MemoryModuleType.WALK_TARGET);
            if (memory.isPresent()) {
                return false;
            }
            Optional lookOptional = brain.getMemory(MemoryModuleType.LOOK_TARGET);
            if (lookOptional.isPresent()) {
                return false;
            }
            Player player = AllayAiMixin.getPlayer(serverLevel, (Brain<? extends LivingEntity>)brain);
            if (player == null || !Objects.equals(player.level(), allay.level())) {
                return false;
            }
            RandomSource random = allay.getRandom();
            EntityTracker target = new EntityTracker((Entity)player, true);
            BlockPos pos = target.currentBlockPosition();
            int i = pos.getX();
            int k = pos.getY();
            int j = pos.getZ();
            BlockPos walkPos = new BlockPos(i += random.nextInt(8) - 4, k += random.nextBoolean() ? 2 : 1, j += random.nextInt(8) - 4);
            if (!serverLevel.isEmptyBlock(walkPos)) {
                walkPos = walkPos.above();
                while (serverLevel.isEmptyBlock(walkPos)) {
                    if (walkPos.getY() > pos.getY() + 6) {
                        return false;
                    }
                    walkPos = walkPos.above();
                }
            }
            if ((center = walkPos.getCenter()).closerThan((Position)(targetPos = target.currentPosition()), 3.0)) {
                return false;
            }
            double pDistance = 4.0;
            double distanceToSqr = center.distanceToSqr(targetPos.x(), targetPos.y(), targetPos.z());
            if (distanceToSqr > pDistance * pDistance) {
                return false;
            }
            look.set((Object)target);
            walk.set((Object)new WalkTarget(walkPos, 1.0f, 0));
            return true;
        }));
    }

    @Unique
    @Nullable
    private static Player getPlayer(ServerLevel serverLevel, Brain<? extends LivingEntity> brain) {
        Optional optional = brain.getMemory(CommonClass.BACKPACK_OWNER_MEMORY.get());
        if (optional.isEmpty()) {
            return null;
        }
        UUID uuid = (UUID)optional.get();
        return serverLevel.getPlayerByUUID(uuid);
    }

    @Unique
    private static BehaviorControl<PathfinderMob> fly(float pSpeedModifier) {
        return AllayAiMixin.strollFlyOrSwim(pSpeedModifier, mob -> {
            Vec3 vec3 = mob.getViewVector(0.0f);
            return AirAndWaterRandomPos.getPos((PathfinderMob)mob, (int)5, (int)1, (int)2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
        });
    }

    @Unique
    private static OneShot<PathfinderMob> strollFlyOrSwim(float pSpeedModifier, Function<PathfinderMob, Vec3> pTarget) {
        return BehaviorBuilder.create(p_258620_ -> p_258620_.group((App)p_258620_.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)p_258620_, p_258600_ -> (p_258610_, p_258611_, p_258612_) -> {
            Optional<Vec3> optional = Optional.ofNullable((Vec3)pTarget.apply((PathfinderMob)p_258611_));
            p_258600_.setOrErase(optional.map(p_258622_ -> new WalkTarget(p_258622_, pSpeedModifier, 0)));
            return true;
        }));
    }
}

