/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={Allay.class})
public abstract class AllayMixin
extends PathfinderMob
implements ViewableAccessor {
    @Unique
    private int teleportToCooldown = 0;
    @Unique
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.defineId(Allay.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ViewableBackpack viewable = new ViewableBackpack(){

        @Override
        public void setOpen(boolean isOpen) {
            AllayMixin.this.getEntityData().set(IS_OPEN, (Object)isOpen);
        }

        @Override
        public boolean isOpen() {
            return (Boolean)AllayMixin.this.getEntityData().get(IS_OPEN);
        }

        @Override
        public void playSound(ModSound.Type type) {
            Traits.get(this.toStack()).ifPresent(traits -> traits.sound().at((Entity)AllayMixin.this, type));
        }

        @Override
        @NotNull
        public Entity entity() {
            return AllayMixin.this;
        }

        @Override
        protected ComponentHolder holder() {
            return ComponentHolder.of(this.toStack());
        }

        @Override
        public ItemStack toStack() {
            return AllayMixin.this.getItemBySlot(EquipmentSlot.BODY);
        }

        @Override
        public boolean shouldClose() {
            if (AllayMixin.this.isRemoved()) {
                return true;
            }
            ItemStack stack = AllayMixin.this.viewable.toStack();
            if (stack.isEmpty()) {
                return true;
            }
            return Traits.get(stack).isEmpty();
        }

        @Override
        public float fallDistance() {
            return AllayMixin.this.fallDistance;
        }
    };

    @Shadow
    public abstract boolean isDancing();

    @Shadow
    protected abstract boolean isDuplicationItem(ItemStack var1);

    @Shadow
    protected abstract boolean canDuplicate();

    protected AllayMixin(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/allay/Allay;isPanicking()Z")})
    private void backpacksTick(CallbackInfo ci) {
        if (this.teleportToCooldown > 0) {
            --this.teleportToCooldown;
            return;
        }
        if (!this.beans_Backpacks_3$tryTeleportToLikedPlayer()) {
            this.teleportToCooldown = 20;
        }
    }

    @Unique
    private boolean beans_Backpacks_3$tryTeleportToLikedPlayer() {
        boolean yawMatches;
        if (this.getVehicle() != null || this.isLeashed()) {
            return true;
        }
        ItemStack backpack = this.getItemBySlot(EquipmentSlot.BODY);
        if (backpack.isEmpty()) {
            return true;
        }
        Optional optional = this.brain.getMemory(CommonClass.BACKPACK_OWNER_MEMORY.get());
        if (optional.isEmpty()) {
            return true;
        }
        UUID uuid = (UUID)optional.get();
        Player player = this.level().getPlayerByUUID(uuid);
        if (player == null) {
            return true;
        }
        float distance = player.distanceTo((Entity)this);
        if (distance < 64.0f) {
            return true;
        }
        float lookRot = player.getYHeadRot();
        Vec3 playPos = player.position();
        Vec3 allayPos = this.position();
        double l = -Math.toDegrees(Math.atan2(allayPos.x - playPos.x, allayPos.z - playPos.z));
        double yaw = Math.abs(l - (double)lookRot) % 360.0 - 180.0;
        boolean bl = yawMatches = Math.abs(yaw) > 90.0;
        if (yawMatches) {
            return true;
        }
        float f1 = -player.getYRot() - (float)Math.PI;
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        int range = 3;
        Vec3 teleportCenter = new Vec3((double)f3, 0.0, (double)f2).multiply((double)range, 1.0, (double)range);
        int iterations = 3;
        for (int i = 0; i < iterations; ++i) {
            int j = this.random.nextIntBetweenInclusive(-range, range);
            int k = this.random.nextIntBetweenInclusive(-range, range);
            Vec3 test = teleportCenter.add((double)j, 0.0, (double)k);
            if (!this.level().noCollision((Entity)this, this.getBoundingBox().move(test))) continue;
            Vec3 finalPos = player.getPosition(1.0f).add(test);
            this.teleportTo(finalPos.x, finalPos.y, finalPos.z);
            return false;
        }
        return true;
    }

    @Inject(method={"mobInteract"}, cancellable=true, at={@At(value="HEAD")})
    private void backpacksMobInteract(Player player, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack inHand = player.getItemInHand(pHand);
        if (this.isDancing() && this.isDuplicationItem(inHand) && this.canDuplicate()) {
            return;
        }
        if (!BackData.get(player).isActionKeyDown()) {
            Optional<GenericTraits> traitsOptional;
            ItemStack bodyArmorItem = this.getItemBySlot(EquipmentSlot.BODY);
            if (!bodyArmorItem.isEmpty() && !(traitsOptional = Traits.get(bodyArmorItem)).isEmpty()) {
                GenericTraits traits = traitsOptional.get();
                traits.onPlayerInteract((LivingEntity)this, player, bodyArmorItem, cir);
            }
            return;
        }
        InteractionResult result = CommonClass.swapBackWith((Allay)this, player);
        if (!InteractionResult.FAIL.equals((Object)result)) {
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"hasItemInHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void backpackHasItemInHand(CallbackInfoReturnable<Boolean> cir) {
        if (!this.getItemBySlot(EquipmentSlot.BODY).isEmpty()) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyArgs(method={"<clinit>"}, at=@At(value="INVOKE", ordinal=0, target="Lcom/google/common/collect/ImmutableList;of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList;"))
    private static void backpackAllayMemory(Args args) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(CommonClass.BACKPACK_OWNER_MEMORY.get());
        int lastArgIndex = args.size() - 1;
        MemoryModuleType[] oldList = (MemoryModuleType[])args.get(lastArgIndex);
        MemoryModuleType[] cleanList = new MemoryModuleType[oldList.length + 1];
        int i = 0;
        MemoryModuleType[] memoryModuleTypeArray = oldList;
        int n = memoryModuleTypeArray.length;
        for (int j = 0; j < n; ++j) {
            MemoryModuleType type;
            cleanList[i] = type = memoryModuleTypeArray[j];
            ++i;
        }
        cleanList[i] = CommonClass.BACKPACK_OWNER_MEMORY.get();
        args.set(lastArgIndex, (Object)cleanList);
    }

    @Override
    public ViewableBackpack beans_Backpacks_3$getViewable() {
        return this.viewable;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void backpackSyncedData(SynchedEntityData.Builder pBuilder, CallbackInfo ci) {
        pBuilder.define(IS_OPEN, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        Optional optional = this.brain.getMemory(CommonClass.BACKPACK_OWNER_MEMORY.get());
        optional.ifPresent(value -> pCompound.putUUID("backpack_owner", value));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.contains("backpack_owner")) {
            UUID owner = pCompound.getUUID("backpack_owner");
            this.brain.setMemory(CommonClass.BACKPACK_OWNER_MEMORY.get(), (Object)owner);
            this.brain.setActiveActivityIfPossible(CommonClass.CHESTER_ACTIVITY.get());
        }
    }

    @Inject(method={"wantsToPickUp"}, cancellable=true, at={@At(value="HEAD")})
    private void wantsToPickUp(ItemStack pStack, CallbackInfoReturnable<Boolean> cir) {
        ItemStack backpack = this.getItemBySlot(EquipmentSlot.BODY);
        if (!backpack.isEmpty()) {
            ComponentHolder holder;
            BackpackMutable mutable;
            BackpackTraits traits = BackpackTraits.get(backpack);
            if (traits != null && (mutable = traits.mutable(holder = ComponentHolder.of(backpack))).toAdd(pStack) > 0) {
                cir.setReturnValue((Object)true);
                return;
            }
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"pickUpItem"}, cancellable=true, at={@At(value="HEAD")})
    private void pickUpItem(ItemEntity pItemEntity, CallbackInfo ci) {
        ItemStack backpack = this.getItemBySlot(EquipmentSlot.BODY);
        if (!backpack.isEmpty()) {
            ci.cancel();
            BackpackTraits traits = BackpackTraits.get(backpack);
            if (traits != null) {
                BackpackMutable mutable = traits.mutable(ComponentHolder.of(backpack));
                ItemStack stack = pItemEntity.getItem();
                int count = stack.getCount();
                if (mutable.addItem(stack) == null) {
                    return;
                }
                int taken = count - stack.getCount();
                this.take((Entity)pItemEntity, taken);
                if (stack.isEmpty()) {
                    pItemEntity.discard();
                }
                mutable.push();
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    List<Pair> slots = List.of(Pair.of((Object)EquipmentSlot.BODY, (Object)this.getItemBySlot(EquipmentSlot.BODY)));
                    ClientboundSetEquipmentPacket packet = new ClientboundSetEquipmentPacket(this.getId(), slots);
                    serverLevel.getChunkSource().broadcast((Entity)this, (Packet)packet);
                }
                traits.sound().at((Entity)this, ModSound.Type.INSERT, 0.5f, 1.0f);
            }
        }
    }
}

