/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ArmorStand.class})
public abstract class ArmorStandMixin
extends LivingEntity
implements ViewableAccessor {
    @Unique
    public final ArmorStand instance = (ArmorStand)this;
    private ItemStack backItem = ItemStack.EMPTY;
    @Unique
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.defineId(ArmorStand.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ViewableBackpack viewable = new ViewableBackpack(){

        @Override
        public void setOpen(boolean isOpen) {
            ArmorStandMixin.this.instance.getEntityData().set(IS_OPEN, (Object)isOpen);
        }

        @Override
        public boolean isOpen() {
            return (Boolean)ArmorStandMixin.this.instance.getEntityData().get(IS_OPEN);
        }

        @Override
        public void playSound(ModSound.Type type) {
            Traits.get(this.toStack()).ifPresent(traits -> traits.sound().at((Entity)ArmorStandMixin.this.instance, type));
        }

        @Override
        @NotNull
        public Entity entity() {
            return ArmorStandMixin.this.instance;
        }

        @Override
        protected ComponentHolder holder() {
            return ComponentHolder.of(this.toStack());
        }

        @Override
        public ItemStack toStack() {
            return ArmorStandMixin.this.instance.getItemBySlot(EquipmentSlot.BODY);
        }

        @Override
        public void onOpen(Player player) {
            super.onOpen(player);
        }

        @Override
        public boolean shouldClose() {
            if (ArmorStandMixin.this.instance.isRemoved()) {
                return true;
            }
            ItemStack stack = ArmorStandMixin.this.viewable.toStack();
            if (stack.isEmpty()) {
                return true;
            }
            return Traits.get(stack).isEmpty();
        }

        @Override
        public float fallDistance() {
            return ArmorStandMixin.this.fallDistance;
        }
    };

    protected ArmorStandMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    protected abstract EquipmentSlot getClickedSlot(Vec3 var1);

    @Shadow
    protected abstract boolean swapItem(Player var1, EquipmentSlot var2, ItemStack var3, InteractionHand var4);

    @Shadow
    public abstract void tick();

    @Shadow
    public abstract boolean isMarker();

    @Inject(method={"interactAt"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="HEAD")})
    private void backpackInteractAt(Player pPlayer, Vec3 pVec, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.isMarker()) {
            return;
        }
        if (!pPlayer.isSpectator() && BackData.get(pPlayer).isActionKeyDown()) {
            InteractionResult result = CommonClass.swapBackWith(this.instance, pPlayer);
            if (result.consumesAction()) {
                cir.setReturnValue((Object)result);
            }
        } else if (!this.getItemBySlot(EquipmentSlot.BODY).isEmpty()) {
            this.interactWithBackpack((LivingEntity)this.instance, pPlayer, pVec, cir);
        }
    }

    @Inject(method={"interactAt"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;getEquipmentSlotForItem(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/EquipmentSlot;")})
    private void backpackInteractAt(Player pPlayer, Vec3 pVec, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir, ItemStack itemstack) {
        BackpackTraits traits = BackpackTraits.get(itemstack);
        if (traits == null) {
            return;
        }
        EquipmentSlot equipmentSlot = null;
        for (EquipmentSlot slot : traits.slots().getValues()) {
            if (EquipmentSlot.BODY.equals((Object)slot)) continue;
            equipmentSlot = slot;
            ItemStack armor = this.getItemBySlot(slot);
            if (!armor.isEmpty()) continue;
            break;
        }
        if (equipmentSlot == null) {
            EquipmentSlot clickedSlot = this.getClickedSlot(pVec);
            if (traits.slots().test(clickedSlot) && this.swapItem(pPlayer, clickedSlot, itemstack, pHand)) {
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
            }
            return;
        }
        if (this.swapItem(pPlayer, equipmentSlot, itemstack, pHand)) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Unique
    private void interactWithBackpack(LivingEntity owner, Player viewer, Vec3 pVec, CallbackInfoReturnable<InteractionResult> cir) {
        double maxRadius;
        double radius;
        boolean looking;
        boolean yawMatches;
        ItemStack backpack = owner.getItemBySlot(EquipmentSlot.BODY);
        if (backpack.isEmpty()) {
            return;
        }
        double yaw = Math.abs(viewer.yHeadRot - owner.yBodyRot) % 360.0f - 180.0f;
        boolean bl = yawMatches = Math.abs(yaw) > 90.0;
        if (!yawMatches) {
            return;
        }
        Optional<GenericTraits> optional = Traits.get(backpack);
        if (optional.isEmpty()) {
            return;
        }
        double angleRadians = Math.toRadians(owner.yBodyRot);
        double offset = -0.3;
        double x = owner.getX();
        double z = owner.getZ();
        double offsetX = Math.cos(angleRadians) * offset;
        double offsetZ = Math.sin(angleRadians) * offset;
        double newX = x - offsetZ;
        double newY = owner.getEyeY() - 0.45;
        double newZ = z + offsetX;
        Vec3 vec3d = viewer.getViewVector(1.0f).normalize();
        Vec3 vec3d2 = new Vec3(newX - viewer.getX(), newY - viewer.getEyeY(), newZ - viewer.getZ());
        double d = -vec3d2.length() + 5.65;
        double e = vec3d.dot(vec3d2.normalize());
        boolean bl2 = looking = e > 1.0 - (radius = d * d * d * d / 625.0) * (maxRadius = 0.05) && viewer.hasLineOfSight((Entity)owner);
        if (!looking) {
            return;
        }
        GenericTraits traits = optional.get();
        traits.onPlayerInteract(owner, viewer, backpack, cir);
    }

    @Inject(method={"getItemBySlot"}, cancellable=true, at={@At(value="HEAD")})
    private void backpackGetItemBySlot(EquipmentSlot pSlot, CallbackInfoReturnable<ItemStack> cir) {
        if (EquipmentSlot.BODY.equals((Object)pSlot)) {
            cir.setReturnValue((Object)this.backItem);
        }
    }

    @Inject(method={"setItemSlot"}, cancellable=true, at={@At(value="HEAD")})
    private void backpackGetItemBySlot(EquipmentSlot pSlot, ItemStack pStack, CallbackInfo ci) {
        if (EquipmentSlot.BODY.equals((Object)pSlot)) {
            this.verifyEquippedItem(pStack);
            this.onEquipItem(pSlot, this.backItem, pStack);
            this.backItem = pStack;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackAddSaveData(CompoundTag pCompound, CallbackInfo ci) {
        Tag backTag = this.backItem.saveOptional((HolderLookup.Provider)this.registryAccess());
        pCompound.put("BackItem", backTag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackReadSaveData(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.contains("BackItem", 10)) {
            this.backItem = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)pCompound.getCompound("BackItem"));
        }
    }

    @Inject(method={"brokenByAnything"}, at={@At(value="TAIL")})
    private void backpackBrokenByAnything(ServerLevel pLevel, DamageSource pDamageSource, CallbackInfo ci) {
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)this.backItem);
        this.backItem = ItemStack.EMPTY;
    }

    @Override
    public ViewableBackpack beans_Backpacks_3$getViewable() {
        return this.viewable;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void backpackSyncedData(SynchedEntityData.Builder pBuilder, CallbackInfo ci) {
        pBuilder.define(IS_OPEN, (Object)false);
    }
}

