/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.network.clientbound.SendItemComponentPatch;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.quiver.QuiverMutable;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.util.Function4;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BowItem.class})
public abstract class BowMixin
extends ProjectileWeaponItem {
    public BowMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Shadow
    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    @Shadow
    public abstract int getUseDuration(ItemStack var1, LivingEntity var2);

    @Inject(method={"releaseUsing"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getProjectile(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;")})
    private void useBackpackQuiverArrow(ItemStack bowStack, Level level, LivingEntity pEntityLiving, int pTimeLeft, CallbackInfo ci) {
        Player player = (Player)pEntityLiving;
        Predicate<ItemStack> predicate = this.getAllSupportedProjectiles();
        QuiverTraits.runIfPresent(player, (Function4<QuiverTraits, Integer, ItemStack, ComponentHolder, Boolean>)((Function4)(proTrait, slot, quiver, holder) -> {
            QuiverMutable mutable = proTrait.mutable((ComponentHolder)holder);
            List<ItemStack> stacks = ((MutableBundleLike)mutable).getItemStacks();
            if (stacks.isEmpty()) {
                return false;
            }
            int slotSafe = ((MutableBundleLike)mutable).getSelectedSlot(player);
            ItemStack stack = stacks.get(slotSafe);
            if (predicate.test(stack)) {
                int i = this.getUseDuration(bowStack, (LivingEntity)player) - pTimeLeft;
                float f = BowItem.getPowerForTime((int)i);
                if (!((double)f + 0.0 < 0.1)) {
                    List list = BowMixin.draw((ItemStack)bowStack, (ItemStack)stack, (LivingEntity)player);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (!list.isEmpty()) {
                            this.shoot(serverLevel, (LivingEntity)player, player.getUsedItemHand(), bowStack, list, f * 3.0f, 1.0f, f == 1.0f, null);
                        }
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    ((MutableBundleLike)mutable).limitSelectedSlot(slotSafe);
                    ((MutableBundleLike)mutable).push();
                    ci.cancel();
                    if (holder instanceof EnderTraits) {
                        EnderTraits enderTraits = (EnderTraits)holder;
                        enderTraits.broadcastChanges();
                    } else if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        SendItemComponentPatch.send(serverPlayer, slot, quiver);
                    }
                }
                return true;
            }
            return false;
        }));
    }
}

