/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.network.clientbound.SendItemComponentPatch;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.quiver.QuiverMutable;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.util.Function4;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ChargedProjectiles;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowMixin
extends ProjectileWeaponItem {
    public CrossbowMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Shadow
    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    @Inject(method={"tryLoadProjectiles"}, cancellable=true, at={@At(value="HEAD")})
    private static void tryLoadQuiverProjectiles(LivingEntity pShooter, ItemStack pCrossbowStack, CallbackInfoReturnable<Boolean> cir) {
        if (pShooter instanceof Player) {
            Player player = (Player)pShooter;
            ProjectileWeaponItem projectileWeaponItem = (ProjectileWeaponItem)pCrossbowStack.getItem();
            Predicate predicate = projectileWeaponItem.getAllSupportedProjectiles();
            QuiverTraits.runIfPresent(player, (Function4<QuiverTraits, Integer, ItemStack, ComponentHolder, Boolean>)((Function4)(proTrait, slot, quiver, holder) -> {
                QuiverMutable mutable = proTrait.mutable((ComponentHolder)holder);
                List<ItemStack> stacks = ((MutableBundleLike)mutable).getItemStacks();
                if (stacks.isEmpty()) {
                    return false;
                }
                int selectedSlotSafe = ((MutableBundleLike)mutable).getSelectedSlot(player);
                ItemStack stack = stacks.get(selectedSlotSafe);
                if (!predicate.test(stack)) {
                    return false;
                }
                List list = CrossbowMixin.draw((ItemStack)pCrossbowStack, (ItemStack)stack, (LivingEntity)player);
                if (list.isEmpty()) {
                    return false;
                }
                pCrossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)list));
                ((MutableBundleLike)mutable).limitSelectedSlot(selectedSlotSafe);
                ((MutableBundleLike)mutable).push();
                cir.setReturnValue((Object)true);
                if (holder instanceof EnderTraits) {
                    EnderTraits enderTraits = (EnderTraits)holder;
                    enderTraits.broadcastChanges();
                } else if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SendItemComponentPatch.send(serverPlayer, slot, quiver);
                }
                return true;
            }));
        }
    }
}

