/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.access.DecoratedPotEntityAccess;
import com.beansgalaxy.backpacks.components.BulkComponent;
import com.beansgalaxy.backpacks.traits.Traits;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DecoratedPotBlockEntity.class})
public abstract class DecoratedPotEntityMixin
extends BlockEntity
implements DecoratedPotEntityAccess,
RandomizableContainer,
ContainerSingleItem.BlockContainerSingleItem {
    @Shadow
    private ItemStack item;
    @Unique
    private final SlotAccess focusedItemAccess = new SlotAccess(){

        public ItemStack get() {
            return DecoratedPotEntityMixin.this.item;
        }

        public boolean set(ItemStack stack) {
            DecoratedPotEntityMixin.this.item = stack;
            return true;
        }
    };
    @Unique
    @Nullable
    BulkComponent bulkContainer = null;

    @Shadow
    public abstract void setTheItem(ItemStack var1);

    public DecoratedPotEntityMixin(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Override
    public SlotAccess item() {
        return this.focusedItemAccess;
    }

    @Override
    @Unique
    @Nullable
    public BulkComponent getBulkComponent() {
        return this.bulkContainer;
    }

    @Override
    public void setBulkComponent(@Nullable BulkComponent bulk) {
        this.bulkContainer = bulk;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries, CallbackInfo ci) {
        if (this.bulkContainer != null) {
            RegistryOps ops = pRegistries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            pTag.put("bulk", (Tag)BulkComponent.CODEC.encodeStart((DynamicOps)ops, (Object)this.bulkContainer).getOrThrow());
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries, CallbackInfo ci) {
        Tag tag = pTag.get("bulk");
        if (tag != null) {
            RegistryOps ops = pRegistries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            this.bulkContainer = BulkComponent.CODEC.parse((DynamicOps)ops, (Object)tag).result().orElse(null);
        }
    }

    @Inject(method={"collectImplicitComponents"}, at={@At(value="TAIL")})
    private void collectImplicitComponents(DataComponentMap.Builder pComponents, CallbackInfo ci) {
        pComponents.set(Traits.BULK, (Object)this.bulkContainer);
    }

    @Inject(method={"applyImplicitComponents"}, at={@At(value="TAIL")})
    private void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput, CallbackInfo ci) {
        this.bulkContainer = (BulkComponent)pComponentInput.get(Traits.BULK);
    }

    public void setItem(int slot, ItemStack stack) {
        switch (slot) {
            case 1: {
                this.insertIntoFocus(stack);
                break;
            }
            case 0: {
                this.setTheItem(stack);
            }
        }
    }

    public int getContainerSize() {
        return this.isFull() ? 1 : 2;
    }

    @Override
    public void setChanged() {
        BulkComponent bulk = this.getBulkComponent();
        if (bulk != null) {
            this.tryFillFocusedItem(bulk.item(), new ArrayList<BulkComponent.ItemlessStack>(bulk.stacks()));
        }
        super.setChanged();
    }
}

