/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.ISlotSelectorTrait;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.util.Function4;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public abstract class InventoryMixin
implements BackData {
    @Shadow
    @Final
    public Player player;
    @Shadow
    @Final
    public NonNullList<ItemStack> items;
    @Unique
    @Final
    public Inventory instance = (Inventory)this;
    private long lastFailedTraitScroll = 0L;

    @Shadow
    public abstract ItemStack getItem(int var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tickCarriedBackpack(CallbackInfo ci) {
        ItemStack carried = this.player.containerMenu.getCarried();
        Level level = this.player.level();
        Traits.get(carried).ifPresent(traits -> carried.inventoryTick(level, (Entity)this.player, -1, false));
        this.getUtility().tick(this.instance);
        for (Slot slot : this.player.containerMenu.slots) {
            ItemStack stack = slot.getItem();
            EnderTraits.get(stack).ifPresent(enderTraits -> {
                Player patt0$temp;
                if (!enderTraits.isLoaded()) {
                    enderTraits.reload(level);
                }
                if ((patt0$temp = this.player) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    enderTraits.addListener(serverPlayer);
                }
            });
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToBackpackBeforeInventory(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!stack.isEmpty()) {
            BackpackTraits bpackTraits = BackpackTraits.get(stack);
            if (bpackTraits != null && bpackTraits.isEmpty(ComponentHolder.of(stack))) {
                for (EquipmentSlot value : bpackTraits.slots().getValues()) {
                    ItemStack itemBySlot = this.player.getItemBySlot(value);
                    if (!itemBySlot.isEmpty()) continue;
                    this.player.setItemSlot(value, stack.copy());
                    stack.setCount(0);
                    cir.setReturnValue((Object)true);
                    return;
                }
                if (!this.player.isCreative()) {
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            BackpackTraits.runIfEquipped(this.player, (traits, equipmentSlot) -> {
                ItemStack backpack = this.player.getItemBySlot(equipmentSlot);
                return traits.pickupToBackpack(this.player, (EquipmentSlot)equipmentSlot, this.instance, backpack, stack, cir);
            });
            QuiverTraits.runIfPresent(this.player, (Function4<QuiverTraits, Integer, ItemStack, ComponentHolder, Boolean>)((Function4)(traits, slot, itemStack, holder) -> traits.pickupToQuiver(this.player, (int)slot, (ItemStack)itemStack, stack, cir)));
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void addToBackpackAfterInventory(int $$0, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            BackpackTraits.runIfEquipped(this.player, (traits, equipmentSlot) -> traits.overflowFromInventory((EquipmentSlot)equipmentSlot, this.player, stack, cir));
        }
    }

    @Inject(method={"swapPaint"}, cancellable=true, at={@At(value="HEAD")})
    private void selectBackpackSlot(double pDirection, CallbackInfo ci) {
        if (this.player.level().isClientSide) {
            long millis = Util.getMillis();
            if (!BackData.get(this.player).isActionKeyDown()) {
                this.lastFailedTraitScroll = millis;
                return;
            }
            if (millis - this.lastFailedTraitScroll < 550L) {
                this.lastFailedTraitScroll = millis;
                return;
            }
            ItemStack inHand = this.player.getItemInHand(InteractionHand.MAIN_HAND);
            ISlotSelectorTrait trait = ISlotSelectorTrait.get(inHand);
            if (trait == null) {
                this.lastFailedTraitScroll = millis;
                return;
            }
            trait.mouseScrolled(this.player, ComponentHolder.of(inHand), -1, -1, (int)Math.signum(pDirection));
            ci.cancel();
        }
    }
}

