/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Unique
    public final ItemStack instance = (ItemStack)this;

    @Shadow
    public abstract Item getItem();

    @Inject(method={"isStackable"}, at={@At(value="HEAD")}, cancellable=true)
    private void backpackIsStackable(CallbackInfoReturnable<Boolean> cir) {
        Traits.runIfPresent(this.instance, traits -> {
            if (!traits.isStackable(ComponentHolder.of(this.instance))) {
                cir.setReturnValue((Object)false);
            }
        });
    }

    @Inject(method={"getTooltipLines"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V")})
    private void backpackTooltipLines(Item.TooltipContext pTooltipContext, Player pPlayer, TooltipFlag pTooltipFlag, CallbackInfoReturnable<List<Component>> cir, List<Component> list) {
        if (BackpackTraits.get(this.instance) != null) {
            return;
        }
        Traits.runIfPresent(this.instance, traits -> traits.client().appendTooltipLines((GenericTraits)traits, list::add));
    }

    @Inject(method={"getTooltipLines"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", ordinal=3, target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private void backpackAdvancedLines(Item.TooltipContext pTooltipContext, Player pPlayer, TooltipFlag pTooltipFlag, CallbackInfoReturnable<List<Component>> cir, List<Component> list) {
        ReferenceTrait referenceTrait = (ReferenceTrait)this.instance.get(Traits.REFERENCE);
        if (referenceTrait == null) {
            return;
        }
        ResourceLocation location = referenceTrait.location();
        list.add((Component)Component.translatable((String)"tooltip.beansbackpacks.advanced.reference", (Object[])new Object[]{location.toString()}).withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
    }

    @Inject(method={"addAttributeTooltips"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/item/ItemStack;forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V")})
    private void backpackAttributeLines(Consumer<Component> pTooltipAdder, Player pPlayer, CallbackInfo ci, @Local EquipmentSlotGroup slotGroup, @Local MutableBoolean mutableboolean) {
        CommonClass.addAttributesToTooltip(pTooltipAdder, slotGroup, mutableboolean, this.instance);
    }

    @Inject(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V"}, at={@At(value="HEAD")})
    private void appendReferenceAttributesForEachSlot(EquipmentSlot pEquipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> pAction, CallbackInfo ci) {
        ReferenceTrait.ifAttributesPresent(this.instance, modifiers -> {
            if (!modifiers.modifiers().isEmpty()) {
                modifiers.forEach(pEquipmentSLot, pAction);
            }
        });
    }

    @Inject(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V"}, at={@At(value="HEAD")})
    private void appendReferenceAttributesForEachGroup(EquipmentSlotGroup pSlotGroup, BiConsumer<Holder<Attribute>, AttributeModifier> pAction, CallbackInfo ci) {
        ReferenceTrait.ifAttributesPresent(this.instance, modifiers -> {
            if (!modifiers.modifiers().isEmpty()) {
                modifiers.forEach(pSlotGroup, pAction);
            }
        });
    }
}

