/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.PlayerAccessor;
import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements ViewableAccessor,
PlayerAccessor {
    @Shadow
    @Final
    private Inventory inventory;
    @Unique
    public final Player instance = (Player)this;
    @Unique
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ViewableBackpack viewable = new ViewableBackpack(){
        Vec3 openedPos = null;
        float openedYaw = 0.0f;

        @Override
        public void setOpen(boolean isOpen) {
            PlayerMixin.this.instance.getEntityData().set(IS_OPEN, (Object)isOpen);
        }

        @Override
        public boolean isOpen() {
            return (Boolean)PlayerMixin.this.instance.getEntityData().get(IS_OPEN);
        }

        @Override
        public void playSound(ModSound.Type type) {
            Traits.get(this.toStack()).ifPresent(traits -> traits.sound().at((Entity)PlayerMixin.this.instance, type));
        }

        @Override
        @NotNull
        public Entity entity() {
            return PlayerMixin.this.instance;
        }

        @Override
        protected ComponentHolder holder() {
            return ComponentHolder.of(this.toStack());
        }

        @Override
        public ItemStack toStack() {
            return PlayerMixin.this.instance.getItemBySlot(EquipmentSlot.BODY);
        }

        @Override
        public void onOpen(Player player) {
            this.openedPos = PlayerMixin.this.instance.position();
            this.openedYaw = PlayerMixin.this.instance.yHeadRot;
            super.onOpen(player);
        }

        @Override
        public boolean shouldClose() {
            if (PlayerMixin.this.instance.isRemoved()) {
                return true;
            }
            ItemStack stack = PlayerMixin.this.viewable.toStack();
            if (stack.isEmpty()) {
                return true;
            }
            if (Traits.get(stack).isEmpty()) {
                return true;
            }
            if (this.openedPos == null) {
                return false;
            }
            if (PlayerMixin.this.instance.distanceToSqr(this.openedPos) > 0.5) {
                return true;
            }
            double yaw = Math.abs(PlayerMixin.this.instance.yHeadRot - this.openedYaw) % 360.0f - 180.0f;
            boolean yawMatches = Math.abs(yaw) > 90.0;
            return !yawMatches;
        }

        @Override
        public float fallDistance() {
            return PlayerMixin.this.fallDistance;
        }
    };
    @Deprecated(since="0.9-beta")
    @Unique
    @Nullable
    private CompoundTag legacyShorthandItems = null;
    @Deprecated(since="0.9-beta")
    @Unique
    private boolean legacyShouldSendShorthandWarning = false;
    @Unique
    private boolean utilitiesScope = false;

    protected PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract void setItemSlot(EquipmentSlot var1, ItemStack var2);

    @Shadow
    public abstract Inventory getInventory();

    @Shadow
    public abstract void displayClientMessage(Component var1, boolean var2);

    @Shadow
    public abstract void remove(Entity.RemovalReason var1);

    @Shadow
    public abstract void travel(Vec3 var1);

    @Override
    public ViewableBackpack beans_Backpacks_3$getViewable() {
        return this.viewable;
    }

    @Inject(method={"getItemBySlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBackSlotItem(EquipmentSlot equipmentSlot, CallbackInfoReturnable<ItemStack> cir) {
        if (equipmentSlot == EquipmentSlot.BODY) {
            BackData access = (BackData)this.instance.getInventory();
            cir.setReturnValue((Object)((ItemStack)access.beans_Backpacks_3$getBody().getFirst()));
        }
    }

    @Inject(method={"setItemSlot"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;verifyEquippedItem(Lnet/minecraft/world/item/ItemStack;)V")})
    private void setBackSlotItem(EquipmentSlot pSlot, ItemStack pStack, CallbackInfo ci) {
        if (EquipmentSlot.BODY.equals((Object)pSlot)) {
            BackData access = (BackData)this.instance.getInventory();
            this.instance.onEquipItem(EquipmentSlot.BODY, (ItemStack)access.beans_Backpacks_3$getBody().set(0, (Object)pStack), pStack);
            ci.cancel();
        }
    }

    @Inject(method={"getProjectile"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/item/ProjectileWeaponItem;getHeldProjectile(Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Lnet/minecraft/world/item/ItemStack;")})
    private void getBackpackProjectile(ItemStack pShootable, CallbackInfoReturnable<ItemStack> cir, Predicate<ItemStack> predicate) {
        QuiverTraits.runIfPresent(this.instance, (Function4<QuiverTraits, Integer, ItemStack, ComponentHolder, Boolean>)((Function4)(proTrait, slot, quiver, holder) -> {
            List<ItemStack> stacks = holder.get(ITraitData.ITEM_STACKS);
            if (stacks == null || stacks.isEmpty()) {
                return false;
            }
            int selectedSlot = proTrait.getSelectedSlot((ComponentHolder)holder, this.instance);
            ItemStack stack = stacks.get(selectedSlot);
            if (predicate.test(stack)) {
                cir.setReturnValue((Object)stack);
                return true;
            }
            return false;
        }));
    }

    @Inject(method={"interactOn"}, cancellable=true, at={@At(value="HEAD")})
    private void backpackInteractOn(Entity pEntityToInteractOn, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (pEntityToInteractOn instanceof Player) {
            Player player = (Player)pEntityToInteractOn;
            CommonClass.interactEquippedBackpack((LivingEntity)player, this.instance, cir);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackAddSaveData(CompoundTag pCompound, CallbackInfo ci) {
        RegistryAccess access = this.instance.registryAccess();
        ItemStack backStack = this.getItemBySlot(EquipmentSlot.BODY);
        CompoundTag backpacks = new CompoundTag();
        RegistryOps serializationContext = access.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DataResult dataResult = ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)serializationContext, (Object)backStack);
        dataResult.ifSuccess(back -> backpacks.put("back", back));
        Inventory inventory = this.getInventory();
        CompoundTag selectedSlots = new CompoundTag();
        PlayerMixin.saveSelectedSlots("items", (List<ItemStack>)inventory.items, this.instance, selectedSlots);
        PlayerMixin.saveSelectedSlots("armor", (List<ItemStack>)inventory.armor, this.instance, selectedSlots);
        ItemStack offhand = (ItemStack)inventory.offhand.getFirst();
        PlayerMixin.saveSelectedSlots("offhand", offhand, this.instance, selectedSlots);
        ItemStack back2 = (ItemStack)BackData.get(this.instance).beans_Backpacks_3$getBody().getFirst();
        PlayerMixin.saveSelectedSlots("back", back2, this.instance, selectedSlots);
        backpacks.put("slot_selection", (Tag)selectedSlots);
        this.legacySaveShorthandBackup(backpacks);
        pCompound.put("beansbackpacks", (Tag)backpacks);
    }

    @Unique
    private static void saveSelectedSlots(String name, List<ItemStack> items, Player instance, CompoundTag tag) {
        int size = items.size();
        CompoundTag slots = new CompoundTag();
        for (int i = 0; i < size; ++i) {
            ItemStack item = items.get(i);
            PlayerMixin.saveSelectedSlots(String.valueOf(i), item, instance, slots);
        }
        tag.put(name, (Tag)slots);
    }

    @Unique
    private static void saveSelectedSlots(String name, ItemStack item, Player instance, CompoundTag tag) {
        SlotSelection slotSelection = (SlotSelection)item.get(ITraitData.SLOT_SELECTION);
        if (slotSelection == null) {
            return;
        }
        int selectedSlot = slotSelection.get(instance);
        if (selectedSlot == 0) {
            return;
        }
        tag.putInt(name, selectedSlot);
    }

    @Unique
    private static int getMaxSelection(ItemStack item) {
        List stacks = (List)item.get(ITraitData.ITEM_STACKS);
        if (stacks == null || stacks.isEmpty()) {
            return 0;
        }
        return stacks.size() - 1;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackReadSaveData(CompoundTag pCompound, CallbackInfo ci) {
        DataResult back;
        CompoundTag backpacks = pCompound.getCompound("beansbackpacks");
        RegistryAccess access = this.instance.registryAccess();
        if (backpacks.contains("back")) {
            Tag backSlot = backpacks.get("back");
            RegistryOps serializationContext = access.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            back = ItemStack.OPTIONAL_CODEC.parse((DynamicOps)serializationContext, (Object)backSlot);
            back.ifSuccess(stack -> this.setItemSlot(EquipmentSlot.BODY, (ItemStack)stack));
        }
        CompoundTag slotSelection = backpacks.getCompound("slot_selection");
        PlayerMixin.readSlotSelection("items", (List<ItemStack>)this.inventory.items, this.instance, slotSelection);
        PlayerMixin.readSlotSelection("armor", (List<ItemStack>)this.inventory.armor, this.instance, slotSelection);
        ItemStack offhand = (ItemStack)this.inventory.offhand.getFirst();
        PlayerMixin.readSlotSelection("offhand", offhand, this.instance, slotSelection);
        back = (ItemStack)BackData.get(this.instance).beans_Backpacks_3$getBody().getFirst();
        PlayerMixin.readSlotSelection("back", (ItemStack)back, this.instance, slotSelection);
        this.legacyReadShorthandBackup(backpacks);
    }

    @Deprecated(since="0.9-beta")
    @Unique
    private void legacySaveShorthandBackup(CompoundTag backpacks) {
        if (this.legacyShorthandItems != null) {
            backpacks.put("shorthand", (Tag)this.legacyShorthandItems);
        }
    }

    @Deprecated(since="0.9-beta")
    @Unique
    private void legacyReadShorthandBackup(CompoundTag backpacks) {
        if (!Services.PLATFORM.isModLoaded("beanstoolbelt") && backpacks.contains("shorthand")) {
            CompoundTag shorthand;
            this.legacyShorthandItems = shorthand = backpacks.getCompound("shorthand");
            this.legacyShouldSendShorthandWarning = true;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    @Deprecated(since="0.9-beta")
    private void legacySendWarningMessage(CallbackInfo ci) {
        if (this.legacyShouldSendShorthandWarning && this.getServer() != null && this.getServer().getConnection() != null) {
            MutableComponent literal = Component.literal((String)"THE SHORTHAND IS NO LONGER INCLUDED IN THIS VERSION OF BEANS' BACKPACKS;");
            MutableComponent literal2 = Component.literal((String)"QUIT THE GAME AND INSTALL \"BEANS' TOOLBELT\" IMMEDIATELY TO KEEP YOUR TOOLS!!");
            this.displayClientMessage((Component)literal, false);
            this.displayClientMessage((Component)literal2, false);
            this.legacyShouldSendShorthandWarning = false;
        }
    }

    @Unique
    private static void readSlotSelection(String name, List<ItemStack> items, Player instance, CompoundTag slotSelection) {
        CompoundTag tag = slotSelection.getCompound(name);
        for (String key : tag.getAllKeys()) {
            int slot = Integer.parseInt(key);
            ItemStack stack = items.get(slot);
            PlayerMixin.readSlotSelection(key, stack, instance, tag);
        }
    }

    @Unique
    private static void readSlotSelection(String name, ItemStack item, Player instance, CompoundTag slotSelection) {
        int selection = slotSelection.getInt(name);
        if (selection == 0) {
            return;
        }
        SlotSelection slotSelection1 = (SlotSelection)item.getOrDefault(ITraitData.SLOT_SELECTION, (Object)new SlotSelection());
        int max = PlayerMixin.getMaxSelection(item);
        slotSelection1.set(instance, Math.min(selection, max));
        item.set(ITraitData.SLOT_SELECTION, (Object)slotSelection1);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void backpackSyncedData(SynchedEntityData.Builder pBuilder, CallbackInfo ci) {
        pBuilder.define(IS_OPEN, (Object)false);
    }

    @Inject(method={"dropEquipment"}, at={@At(value="HEAD")})
    private void backpackDropEquipment(CallbackInfo ci) {
        if (!ServerSave.CONFIG.keepBackpack(this.level())) {
            BackpackEntity.drop(this.instance);
        }
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
                List stacks;
                ItemStack backpack = this.instance.getItemBySlot(slot);
                BackpackTraits traits = BackpackTraits.get(backpack);
                if (traits == null || (stacks = (List)backpack.remove(ITraitData.ITEM_STACKS)) == null) continue;
                for (ItemStack stack : stacks) {
                    this.instance.drop(stack, true, false);
                }
            }
        }
    }

    @Override
    public boolean isUtilityScoped() {
        return this.utilitiesScope;
    }

    @Override
    public void setUtilityScoped(boolean isScoped) {
        this.utilitiesScope = isScoped;
    }

    @Inject(method={"isScoping"}, cancellable=true, at={@At(value="TAIL")})
    private void backpacks_isScoping(CallbackInfoReturnable<Boolean> cir) {
        if (this.utilitiesScope) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void setItemUsed(ItemStack itemstack) {
        if (!itemstack.isEmpty() && !this.isUsingItem()) {
            this.useItem = itemstack;
            this.useItemRemaining = itemstack.getUseDuration((LivingEntity)this);
            if (!this.level().isClientSide) {
                this.setLivingEntityFlag(1, true);
                this.setLivingEntityFlag(2, false);
                this.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
            }
        }
    }
}

