/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network;

import com.beansgalaxy.backpacks.network.clientbound.ConfigureConfig;
import com.beansgalaxy.backpacks.network.clientbound.ConfigureReferences;
import com.beansgalaxy.backpacks.network.clientbound.Packet2C;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderEntry;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderTraits;
import com.beansgalaxy.backpacks.network.clientbound.SendItemComponentPatch;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public enum Network2C {
    ENDER_TRAIT_2C(SendEnderTraits.class, SendEnderTraits.ID, SendEnderTraits::encode, SendEnderTraits::new, SendEnderTraits::handle),
    ENDER_ENTRY_2C(SendEnderEntry.class, SendEnderEntry.ID, SendEnderEntry::encode, SendEnderEntry::decode, SendEnderEntry::handle),
    CONFIG_REFERENCES_2C(ConfigureReferences.class, ConfigureReferences.ID, ConfigureReferences::encode, ConfigureReferences::new, ConfigureReferences::handle),
    CONFIG_COMMON_2C(ConfigureConfig.class, ConfigureConfig.ID, ConfigureConfig::encode, ConfigureConfig::new, ConfigureConfig::handle),
    INVENTORY_ITEM_2C(SendItemComponentPatch.class, SendItemComponentPatch.ID, SendItemComponentPatch::encode, SendItemComponentPatch::new, SendItemComponentPatch::handle);

    public final DynamicLoaderPacket<? super RegistryFriendlyByteBuf, ?> packet;

    private <T extends Packet2C> Network2C(Class<T> clazz, CustomPacketPayload.Type<T> id, BiConsumer<T, RegistryFriendlyByteBuf> encoder, Function<RegistryFriendlyByteBuf, T> decoder, Consumer<T> handle) {
        this.packet = new DynamicLoaderPacket<RegistryFriendlyByteBuf, T>(clazz, id, encoder, decoder, handle);
    }

    public void debugMsgEncode() {
    }

    public void debugMsgDecode() {
    }

    public class DynamicLoaderPacket<B extends RegistryFriendlyByteBuf, T extends Packet2C>
    implements StreamCodec<B, T> {
        public final Class<T> clazz;
        public final CustomPacketPayload.Type<T> type;
        private final BiConsumer<T, B> encoder;
        private final Function<B, T> decoder;
        private final Consumer<T> handle;

        private DynamicLoaderPacket(Class<T> clazz, CustomPacketPayload.Type<T> type, BiConsumer<T, B> encoder, Function<B, T> decoder, Consumer<T> handle) {
            this.clazz = clazz;
            this.type = type;
            this.encoder = encoder;
            this.decoder = decoder;
            this.handle = handle;
        }

        @NotNull
        public T decode(@NotNull B buf) {
            Network2C.this.debugMsgDecode();
            return (T)((Packet2C)this.decoder.apply(buf));
        }

        public void encode(@NotNull B buf, @NotNull T msg) {
            Network2C.this.debugMsgEncode();
            this.encoder.accept(msg, buf);
        }

        public void handle(T msg) {
            this.handle.accept(msg);
        }

        public String toString() {
            return this.getClass().getName() + " [" + String.valueOf(this.type.id()) + "]";
        }
    }
}

