/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.clientbound;

import com.beansgalaxy.backpacks.components.reference.ReferenceRegistry;
import com.beansgalaxy.backpacks.network.Network2C;
import com.beansgalaxy.backpacks.network.clientbound.Packet2C;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ConfigureReferences
implements Packet2C {
    final Map<ResourceLocation, ReferenceRegistry> references;
    public static CustomPacketPayload.Type<ConfigureReferences> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:config_references_c"));

    private ConfigureReferences(Map<ResourceLocation, ReferenceRegistry> references) {
        this.references = references;
    }

    public ConfigureReferences(RegistryFriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<ResourceLocation, ReferenceRegistry> map = new HashMap<ResourceLocation, ReferenceRegistry>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation location = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
            ReferenceRegistry reference = (ReferenceRegistry)ReferenceRegistry.STREAM_CODEC.decode((Object)buf);
            map.put(location, reference);
        }
        this.references = map;
    }

    public static void send(ServerPlayer player) {
        new ConfigureReferences(ReferenceRegistry.REFERENCES).send2C(player);
    }

    @Override
    public Network2C getNetwork() {
        return Network2C.CONFIG_REFERENCES_2C;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        int size = this.references.size();
        buf.writeInt(size);
        this.references.forEach((location, reference) -> {
            ResourceLocation.STREAM_CODEC.encode((Object)buf, location);
            ReferenceRegistry.STREAM_CODEC.encode((Object)buf, reference);
        });
    }

    @Override
    public void handle() {
        ReferenceRegistry.REFERENCES.clear();
        this.references.forEach(ReferenceRegistry::put);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

