/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.clientbound;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.network.Network2C;
import com.beansgalaxy.backpacks.network.clientbound.Packet2C;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SendEnderEntry<T extends GenericTraits>
implements Packet2C {
    private final Reference2ObjectOpenHashMap<DataComponentType<?>, Object> map;
    private final TraitComponentKind<T> kind;
    private final T trait;
    private final ResourceLocation location;
    private final Component name;
    private final UUID owner;
    public static CustomPacketPayload.Type<SendEnderEntry> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:send_ender_entry_c"));

    public static SendEnderEntry<?> decode(RegistryFriendlyByteBuf buf) {
        return new SendEnderEntry<GenericTraits>(buf.readUUID(), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf), (GenericTraits)((TraitComponentKind)TraitComponentKind.STREAM_CODEC.decode((Object)buf)).streamCodec().decode((Object)buf), (Reference2ObjectOpenHashMap)EnderStorage.ENTRY_MAP_STREAM_CODEC.decode((Object)buf), (Component)Component.Serializer.fromJson((String)buf.readUtf(), (HolderLookup.Provider)buf.registryAccess()));
    }

    public SendEnderEntry(UUID owner, ResourceLocation location, T trait, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> data, Component name) {
        this(owner, location, ((GenericTraits)trait).kind(), (GenericTraits)trait, data, name);
    }

    private SendEnderEntry(UUID owner, ResourceLocation location, TraitComponentKind<T> kind, T trait, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> data, Component name) {
        this.owner = owner;
        this.location = location;
        this.kind = kind;
        this.trait = trait;
        this.map = data;
        this.name = name;
    }

    public static <T extends GenericTraits> void send(ServerPlayer sender, UUID owner, ResourceLocation location, TraitComponentKind<T> kind, T trait, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> data, Component displayName) {
        new SendEnderEntry<T>(owner, location, kind, trait, data, displayName).send2C(sender);
    }

    @Override
    public Network2C getNetwork() {
        return Network2C.ENDER_ENTRY_2C;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.owner);
        ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)this.location);
        TraitComponentKind.STREAM_CODEC.encode((Object)buf, this.kind);
        TraitComponentKind.encode(buf, this.trait);
        EnderStorage.ENTRY_MAP_STREAM_CODEC.encode((Object)buf, this.map);
        String json = Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)buf.registryAccess());
        buf.writeUtf(json);
    }

    @Override
    public void handle() {
        EnderStorage enderStorage = CommonClient.getEnderStorage();
        enderStorage.set(this.owner, this.location, this.kind, this.trait, this.map, this.name);
    }

    public CustomPacketPayload.Type<SendEnderEntry> type() {
        return ID;
    }
}

