/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.clientbound;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.network.Network2C;
import com.beansgalaxy.backpacks.network.clientbound.Packet2C;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SendEnderTraits
implements Packet2C {
    private final UUID owner;
    private final ResourceLocation location;
    private final Reference2ObjectOpenHashMap<DataComponentType<?>, Object> map;
    public static CustomPacketPayload.Type<SendEnderTraits> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:send_ender_traits_c"));

    public SendEnderTraits(RegistryFriendlyByteBuf buf) {
        this.owner = buf.readUUID();
        this.location = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
        this.map = (Reference2ObjectOpenHashMap)EnderStorage.ENTRY_MAP_STREAM_CODEC.decode((Object)buf);
    }

    private SendEnderTraits(UUID owner, ResourceLocation location, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> map) {
        this.owner = owner;
        this.location = location;
        this.map = map;
    }

    public static void send(ServerPlayer sender, UUID owner, ResourceLocation location) {
        Reference2ObjectOpenHashMap<DataComponentType<?>, Object> traits = EnderStorage.get(sender.level()).get(owner, location);
        new SendEnderTraits(owner, location, traits).send2C(sender);
    }

    @Override
    public Network2C getNetwork() {
        return Network2C.ENDER_TRAIT_2C;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.owner);
        ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)this.location);
        EnderStorage.ENTRY_MAP_STREAM_CODEC.encode((Object)buf, this.map);
    }

    @Override
    public void handle() {
        CommonClient.getEnderStorage().set(this.owner, this.location, this.map);
    }

    public CustomPacketPayload.Type<SendEnderTraits> type() {
        return ID;
    }
}

