/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.serverbound;

import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.util.ModSound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;

public class BackpackUseOn
implements Packet2S {
    public static final CustomPacketPayload.Type<BackpackUseOn> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:place_backpack_s"));
    private final BlockHitResult blockHitResult;
    private final EquipmentSlot equipmentSlot;

    public BackpackUseOn(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockHitResult(), (EquipmentSlot)buf.readEnum(EquipmentSlot.class));
    }

    private BackpackUseOn(BlockHitResult blockHitResult, EquipmentSlot slot) {
        this.blockHitResult = blockHitResult;
        this.equipmentSlot = slot;
    }

    public static void send(BlockHitResult hitResult, EquipmentSlot slot) {
        new BackpackUseOn(hitResult, slot).send2S();
    }

    @Override
    public Network2S getNetwork() {
        return Network2S.PLACE_BACKPACK_2S;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeBlockHitResult(this.blockHitResult);
        buf.writeEnum((Enum)this.equipmentSlot);
    }

    @Override
    public void handle(Player sender) {
        ItemStack backpack = sender.getItemBySlot(this.equipmentSlot);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return;
        }
        BackpackUseOn.placeBackpack(sender, this.blockHitResult, backpack, traits);
    }

    public static boolean placeBackpack(Player player, BlockHitResult hitResult, ItemStack backpack, BackpackTraits traits) {
        UseOnContext context = new UseOnContext(player, InteractionHand.MAIN_HAND, hitResult);
        BackpackEntity entity = BackpackEntity.create(context, backpack, traits);
        if (entity == null) {
            return false;
        }
        traits.sound().at(entity, ModSound.Type.PLACE);
        return true;
    }

    public CustomPacketPayload.Type<BackpackUseOn> type() {
        return ID;
    }
}

