/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.serverbound;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public class InstantKeyPress
implements Packet2S {
    private final int entity;
    public static CustomPacketPayload.Type<InstantKeyPress> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:instant_key_press_s"));

    private InstantKeyPress(int entity) {
        this.entity = entity;
    }

    public InstantKeyPress(RegistryFriendlyByteBuf buf) {
        this(buf.readInt());
    }

    public static void send(int entity) {
        new InstantKeyPress(entity).send2S();
    }

    @Override
    public Network2S getNetwork() {
        return Network2S.INSTANT_KEY_2S;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entity);
    }

    @Override
    public void handle(Player sender) {
        Entity entity = sender.level().getEntity(this.entity);
        if (entity instanceof BackpackEntity) {
            BackpackEntity backpack = (BackpackEntity)entity;
            backpack.tryEquip(sender);
        } else if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            CommonClass.swapBackWith(armorStand, sender);
        } else if (entity instanceof Allay) {
            Allay allay = (Allay)entity;
            CommonClass.swapBackWith(allay, sender);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

