/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.serverbound;

import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.ISlotSelectorTrait;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SyncSelectedSlot
implements Packet2S {
    final int containerId;
    final int slotIndex;
    final int selectedSlot;
    public static CustomPacketPayload.Type<SyncSelectedSlot> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:sync_selected_slot_s"));

    private SyncSelectedSlot(int containerId, int slotIndex, int selectedSlot) {
        this.containerId = containerId;
        this.slotIndex = slotIndex;
        this.selectedSlot = selectedSlot;
    }

    public SyncSelectedSlot(RegistryFriendlyByteBuf buf) {
        this.containerId = buf.readInt();
        this.slotIndex = buf.readInt();
        this.selectedSlot = buf.readInt();
    }

    public static void send(int containerId, int slotIndex, int selectedSlot) {
        new SyncSelectedSlot(containerId, slotIndex, selectedSlot).send2S();
    }

    @Override
    public Network2S getNetwork() {
        return Network2S.SYNC_SELECTED_SLOT_2S;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.containerId);
        buf.writeInt(this.slotIndex);
        buf.writeInt(this.selectedSlot);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Player sender) {
        SlotSelection selection;
        ComponentHolder holder;
        ItemStack stack;
        if (this.containerId == -1) {
            if (this.slotIndex != -1) {
                return;
            }
            stack = sender.getItemInHand(InteractionHand.MAIN_HAND);
        } else {
            AbstractContainerMenu containerMenu = sender.containerMenu;
            if (containerMenu.containerId != this.containerId) {
                return;
            }
            Slot slot = containerMenu.getSlot(this.slotIndex);
            stack = slot.getItem();
        }
        if (stack.isEmpty()) {
            return;
        }
        ISlotSelectorTrait selectorTrait = ISlotSelectorTrait.get(stack);
        if (selectorTrait == null) {
            EnderTraits enderTraits = (EnderTraits)stack.get(Traits.ENDER);
            if (enderTraits == null) {
                return;
            }
            GenericTraits generic = enderTraits.getTrait(sender.level());
            if (!(generic instanceof ISlotSelectorTrait)) return;
            holder = enderTraits;
        } else {
            holder = ComponentHolder.of(stack);
        }
        if ((selection = holder.get(ITraitData.SLOT_SELECTION)) == null) {
            selection = new SlotSelection();
        }
        selection.set(sender, this.selectedSlot);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

