/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.serverbound;

import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.IEntityTraits;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.ItemStorageTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TinyHotbarClick
implements Packet2S {
    private final int entityId;
    private final int index;
    private final TinyClickType clickType;
    public static CustomPacketPayload.Type<TinyHotbarClick> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:tiny_hotbar_click_s"));

    public TinyHotbarClick(RegistryFriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.index = buf.readInt();
        this.clickType = (TinyClickType)buf.readEnum(TinyClickType.class);
    }

    public TinyHotbarClick(int entityId, int index, TinyClickType clickType) {
        this.entityId = entityId;
        this.index = index;
        this.clickType = clickType;
    }

    public static void send(ViewableBackpack backpack, int index, TinyClickType clickType) {
        new TinyHotbarClick(backpack.getId(), index, clickType).send2S();
    }

    @Override
    public Network2S getNetwork() {
        return Network2S.TINY_HOTBAR_2S;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.index);
        buf.writeEnum((Enum)this.clickType);
    }

    @Override
    public void handle(Player sender) {
        Entity entity = sender.level().getEntity(this.entityId);
        if (entity instanceof BackpackEntity) {
            BackpackEntity backpack = (BackpackEntity)entity;
            IEntityTraits<?> traits = backpack.getTraits();
            traits.tinyHotbarClick(backpack, this.index, this.clickType, sender.inventoryMenu, sender);
        } else {
            GenericTraits genericTraits;
            if (!(entity instanceof ViewableAccessor)) {
                return;
            }
            LivingEntity owner = (LivingEntity)entity;
            ItemStack backpack = owner.getItemBySlot(EquipmentSlot.BODY);
            Optional<GenericTraits> optional = Traits.get(backpack);
            if (optional.isPresent() && (genericTraits = optional.get()) instanceof ItemStorageTraits) {
                ItemStorageTraits storageTraits = (ItemStorageTraits)genericTraits;
                storageTraits.tinyHotbarClick(ComponentHolder.of(backpack), this.index, this.clickType, sender.inventoryMenu, sender);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

