/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.serverbound;

import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class TinyMenuInteract
implements Packet2S {
    private final int entity;
    private final boolean isOpen;
    public static CustomPacketPayload.Type<TinyMenuInteract> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:tiny_menu_interact_s"));

    private TinyMenuInteract(int entity, boolean isOpen) {
        this.entity = entity;
        this.isOpen = isOpen;
    }

    public TinyMenuInteract(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean());
    }

    public static void send(int entity, boolean isOpen) {
        new TinyMenuInteract(entity, isOpen).send2S();
    }

    @Override
    public Network2S getNetwork() {
        return Network2S.TINY_INTERACT_2S;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.entity);
        buf.writeBoolean(this.isOpen);
    }

    @Override
    public void handle(Player sender) {
        Entity entity = sender.level().getEntity(this.entity);
        if (entity instanceof BackpackEntity) {
            BackpackEntity backpack = (BackpackEntity)entity;
            if (this.isOpen) {
                backpack.viewable.onOpen(sender);
            } else {
                backpack.viewable.onClose(sender);
            }
        } else {
            if (!(entity instanceof ViewableAccessor)) {
                return;
            }
            ViewableAccessor accessor = (ViewableAccessor)entity;
            ViewableBackpack viewable = accessor.beans_Backpacks_3$getViewable();
            if (this.isOpen) {
                viewable.onOpen(sender);
            } else {
                viewable.onClose(sender);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

