/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.serverbound;

import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TraitMenuClick
implements Packet2S {
    private final int containerId;
    private final int containerSlot;
    private final int index;
    private final Kind clickType;
    public static CustomPacketPayload.Type<TraitMenuClick> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:trait_menu_click_s"));

    public TraitMenuClick(RegistryFriendlyByteBuf buf) {
        this.containerId = buf.readInt();
        this.containerSlot = buf.readInt();
        this.index = buf.readInt();
        this.clickType = (Kind)buf.readEnum(Kind.class);
    }

    public TraitMenuClick(int containerId, int containerSlot, int index, Kind clickType) {
        this.containerId = containerId;
        this.containerSlot = containerSlot;
        this.index = index;
        this.clickType = clickType;
    }

    public static void send(int containerId, Slot slot, int index, Kind clickType) {
        new TraitMenuClick(containerId, slot.index, index, clickType).send2S();
    }

    @Override
    public Network2S getNetwork() {
        return Network2S.TRAIT_MENU_CLICK;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.containerId);
        buf.writeInt(this.containerSlot);
        buf.writeInt(this.index);
        buf.writeEnum((Enum)this.clickType);
    }

    @Override
    public void handle(Player sender) {
        GenericTraits traits;
        final AbstractContainerMenu menu = sender.containerMenu;
        if (menu.containerId != this.containerId) {
            return;
        }
        Slot slot = menu.getSlot(this.containerSlot);
        ComponentHolder holder = ComponentHolder.of(slot);
        Optional<GenericTraits> optional = Traits.get(holder);
        if (optional.isEmpty()) {
            Optional<EnderTraits> optionalEnder = EnderTraits.get(slot.getItem());
            if (optionalEnder.isEmpty()) {
                return;
            }
            EnderTraits enderTraits = optionalEnder.get();
            traits = enderTraits.getTrait(sender.level());
        } else {
            traits = optional.get();
        }
        SlotAccess carriedAccess = new SlotAccess(){

            public ItemStack get() {
                return menu.getCarried();
            }

            public boolean set(ItemStack p_150452_) {
                menu.setCarried(p_150452_);
                return true;
            }
        };
        traits.menuClick(holder, this.index, this.clickType, carriedAccess, sender);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static enum Kind {
        LEFT,
        RIGHT,
        SHIFT,
        ACTION,
        DROP;


        public boolean isShift() {
            return this == SHIFT;
        }

        public boolean isAction() {
            return this == ACTION;
        }

        public boolean isDrop() {
            return this == DROP;
        }

        public boolean isRight() {
            return this == RIGHT;
        }
    }
}

