/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.network.serverbound;

import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class UtilitiesUse
implements Packet2S {
    private final Kind kind;
    public static CustomPacketPayload.Type<UtilitiesUse> ID = new CustomPacketPayload.Type(ResourceLocation.parse((String)"beansbackpacks:utility_rocket_use_s"));

    private UtilitiesUse(Kind kind) {
        this.kind = kind;
    }

    public UtilitiesUse(RegistryFriendlyByteBuf buf) {
        this((Kind)buf.readEnum(Kind.class));
    }

    public static void sendRocket() {
        new UtilitiesUse(Kind.ROCKET).send2S();
    }

    @Override
    public Network2S getNetwork() {
        return Network2S.UTILITY_ROCKET_USE;
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.kind);
    }

    @Override
    public void handle(Player pPlayer) {
        switch (this.kind.ordinal()) {
            case 0: {
                UtilitiesUse.useRocket(pPlayer);
            }
        }
    }

    private static void useRocket(Player pPlayer) {
        if (!pPlayer.isFallFlying()) {
            return;
        }
        UtilityComponent.testItems(pPlayer, (itemstack, mute) -> {
            Item rocket = Items.FIREWORK_ROCKET;
            if (!itemstack.is(rocket)) {
                return false;
            }
            Level pLevel = pPlayer.level();
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(pLevel, itemstack, (LivingEntity)pPlayer);
            pLevel.addFreshEntity((Entity)fireworkrocketentity);
            itemstack.consume(1, (LivingEntity)pPlayer);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)rocket));
            mute.freeze();
            return true;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private static enum Kind {
        ROCKET;

    }
}

