/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.platform;

import com.beansgalaxy.backpacks.BurlapSackEntity;
import com.beansgalaxy.backpacks.Registries;
import com.beansgalaxy.backpacks.items.AbstractBurlapSackEntity;
import com.beansgalaxy.backpacks.network.Network2C;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.clientbound.Packet2C;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.platform.services.IPlatformHelper;
import com.beansgalaxy.backpacks.screen.BurlapSackMenu;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforgespi.language.IModInfo;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    public static final DeferredRegister.Blocks BLOCK_REGISTRY = DeferredRegister.createBlocks((String)"beansbackpacks");
    public static final DeferredRegister.Items ITEMS_REGISTRY = DeferredRegister.createItems((String)"beansbackpacks");
    public static final DeferredRegister.DataComponents COMPONENTS_REGISTRY = DeferredRegister.createDataComponents((String)"beansbackpacks");
    public static final DeferredRegister<EntityType<?>> ENTITY_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"beansbackpacks");
    public static final DeferredRegister<SoundEvent> SOUND_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"beansbackpacks");
    public static final DeferredRegister<Attribute> ATTRIBUTE_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ATTRIBUTE, (String)"beansbackpacks");
    public static final DeferredRegister<Activity> ACTIVITY_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ACTIVITY, (String)"beansbackpacks");
    public static final DeferredRegister<MemoryModuleType<?>> MEMORY_MODULE_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.MEMORY_MODULE_TYPE, (String)"beansbackpacks");

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void send(Network2C network, Packet2C packet2C, ServerPlayer to) {
        PacketDistributor.sendToPlayer((ServerPlayer)to, (CustomPacketPayload)packet2C, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void send(Network2C network, Packet2C packet2C, MinecraftServer server) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet2C, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void send(Network2C network, Packet2C packet2C, MinecraftServer server, ServerPlayer player) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)packet2C, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void send(Network2S network, Packet2S packet2S) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet2S, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Supplier<Item> register(String name, Supplier<Item> item) {
        return ITEMS_REGISTRY.register(name, item);
    }

    @Override
    public Supplier<Block> registerBlock(String id, Supplier<Block> block) {
        return BLOCK_REGISTRY.register(id, block);
    }

    @Override
    public BlockEntityType<? extends AbstractBurlapSackEntity> getBurlapSackEntityType() {
        return Registries.BURLAP_SACK_ENTITY.get();
    }

    @Override
    public MenuType<BurlapSackMenu> getBurlapSackMenuType() {
        return Registries.BURLAP_SACK_MENU.get();
    }

    @Override
    public BlockEntity createBurlapSackEntity(BlockPos pos, BlockState state) {
        return new BurlapSackEntity(pos, state);
    }

    @Override
    public <T> DataComponentType<T> register(String name, DataComponentType<T> type) {
        DeferredRegister.DataComponents components = COMPONENTS_REGISTRY;
        components.register(name, () -> type);
        return type;
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> register(String name, EntityType.Builder<T> type) {
        DeferredRegister<EntityType<?>> registry = ENTITY_REGISTRY;
        return registry.register(name, () -> type.build(name));
    }

    @Override
    public SoundEvent register(String name, SoundEvent event) {
        DeferredRegister<SoundEvent> registry = SOUND_REGISTRY;
        registry.register(name, () -> event);
        return event;
    }

    @Override
    public Holder<Attribute> register(String name, Attribute attribute) {
        return ATTRIBUTE_REGISTRY.register(name, () -> attribute);
    }

    @Override
    public Supplier<Activity> registerActivity(String name) {
        return ACTIVITY_REGISTRY.register(name, () -> new Activity(name));
    }

    @Override
    public <T> Supplier<MemoryModuleType<T>> registerMemoryModule(String name, Codec<T> codec) {
        return MEMORY_MODULE_REGISTRY.register(name, () -> new MemoryModuleType(Optional.of(codec)));
    }

    @Override
    public ModelResourceLocation getModelVariant(ResourceLocation location) {
        return ModelResourceLocation.standalone((ResourceLocation)location);
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Optional<Path> getModFeaturesDir() {
        Optional optional = ModList.get().getModContainerById("beansbackpacks");
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        IModInfo modInfo = ((ModContainer)optional.get()).getModInfo();
        Path resourcePath = modInfo.getOwningFile().getFile().findResource(new String[]{"features"});
        return Optional.ofNullable(resourcePath);
    }
}

