/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.platform.services;

import com.beansgalaxy.backpacks.items.AbstractBurlapSackEntity;
import com.beansgalaxy.backpacks.network.Network2C;
import com.beansgalaxy.backpacks.network.Network2S;
import com.beansgalaxy.backpacks.network.clientbound.Packet2C;
import com.beansgalaxy.backpacks.network.serverbound.Packet2S;
import com.beansgalaxy.backpacks.screen.BurlapSackMenu;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public Supplier<Item> register(String var1, Supplier<Item> var2);

    public Supplier<Block> registerBlock(String var1, Supplier<Block> var2);

    public BlockEntityType<? extends AbstractBurlapSackEntity> getBurlapSackEntityType();

    public <T> DataComponentType<T> register(String var1, DataComponentType<T> var2);

    public <T extends Entity> Supplier<EntityType<T>> register(String var1, EntityType.Builder<T> var2);

    public SoundEvent register(String var1, SoundEvent var2);

    public Holder<Attribute> register(String var1, Attribute var2);

    public Supplier<Activity> registerActivity(String var1);

    public <T> Supplier<MemoryModuleType<T>> registerMemoryModule(String var1, Codec<T> var2);

    public void send(Network2C var1, Packet2C var2, ServerPlayer var3);

    public void send(Network2C var1, Packet2C var2, MinecraftServer var3);

    public void send(Network2C var1, Packet2C var2, MinecraftServer var3, ServerPlayer var4);

    public void send(Network2S var1, Packet2S var2);

    public ModelResourceLocation getModelVariant(ResourceLocation var1);

    public Path getConfigDir();

    public Optional<Path> getModFeaturesDir();

    default public Path getConfigPath() {
        return this.getConfigDir().resolve("beansbackpacks");
    }

    public MenuType<BurlapSackMenu> getBurlapSackMenuType();

    public BlockEntity createBurlapSackEntity(BlockPos var1, BlockState var2);
}

