/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.network.serverbound.TinyMenuInteract;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackpackScreen
extends EffectRenderingInventoryScreen<InventoryMenu> {
    protected final List<TraitSlot> slots = new ArrayList<TraitSlot>();
    protected int traitX = 0;
    protected int traitY = 0;
    protected int traitW = 0;
    protected int traitH = 0;
    protected final ViewableBackpack backpack;

    public BackpackScreen(InventoryMenu pMenu, Inventory pPlayerInventory, ViewableBackpack backpack) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, (Component)Component.translatable((String)"container.crafting"));
        this.backpack = backpack;
        this.titleLabelX = 97;
    }

    protected void init() {
        super.init();
        Window window = this.minecraft.getWindow();
        int scaledHeight = window.getGuiScaledHeight();
        int scaledWidth = window.getGuiScaledWidth();
        this.leftPos = scaledWidth / 2 - 12;
        this.topPos = scaledHeight / 2 - 83;
    }

    public void onClose() {
        this.minecraft.setScreen(null);
        TinyMenuInteract.send(this.backpack.getId(), false);
    }

    protected abstract void tinyMenuClick(int var1, TinyClickType var2, SlotAccess var3, LocalPlayer var4);

    protected abstract void tinyHotbarClick(TinyClickType var1, InventoryMenu var2, LocalPlayer var3, int var4);

    protected static TinyClickType getClickType(Minecraft minecraft, int button, Player player) {
        boolean eitherShiftDown;
        BackData backData = BackData.get(player);
        if (backData.isMenuKeyDown() && backData.getTinySlot() == -1) {
            return TinyClickType.ACTION;
        }
        boolean bl = eitherShiftDown = InputConstants.isKeyDown((long)minecraft.getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)minecraft.getWindow().getWindow(), (int)344);
        if (eitherShiftDown) {
            return TinyClickType.SHIFT;
        }
        if (button == 1) {
            return TinyClickType.RIGHT;
        }
        return TinyClickType.LEFT;
    }

    protected void slotClicked(@NotNull Slot pSlot, int pSlotId, int pMouseButton, @NotNull ClickType pType) {
        LocalPlayer player = this.minecraft.player;
        if (pSlot == null) {
            this.minecraft.gameMode.handleInventoryMouseClick(((InventoryMenu)this.menu).containerId, pSlotId, pMouseButton, pType, (Player)player);
            return;
        }
        if (pType == ClickType.QUICK_MOVE) {
            TinyClickType tinyType = pSlot instanceof ResultSlot ? TinyClickType.CRAFT : TinyClickType.SHIFT;
            this.tinyHotbarClick(tinyType, (InventoryMenu)this.menu, player, pSlot.index);
        } else {
            this.minecraft.gameMode.handleInventoryMouseClick(((InventoryMenu)this.menu).containerId, pSlot.index, pMouseButton, pType, (Player)player);
        }
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return Stream.concat(super.children().stream(), this.slots.stream()).toList();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        TraitSlot slot = this.getHoveredSlot();
        if (slot != null) {
            Options options = this.minecraft.options;
            if (options.keyDrop.matches(pKeyCode, pScanCode)) {
                slot.dropItem();
                return true;
            }
            KeyMapping[] hotbarSlots = options.keyHotbarSlots;
            for (int i = 0; i < hotbarSlots.length; ++i) {
                KeyMapping hotbarSlot = hotbarSlots[i];
                if (!hotbarSlot.matches(pKeyCode, pScanCode)) continue;
                slot.hotbarClick(i);
                return true;
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Nullable
    private TraitSlot getHoveredSlot() {
        MouseHandler mouseHandler = this.minecraft.mouseHandler;
        double x = mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        double y = mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
        for (TraitSlot slot : this.slots) {
            if (!slot.isMouseOver(x, y)) continue;
            return slot;
        }
        return null;
    }

    public void render(@NotNull GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.backpack.shouldClose()) {
            this.onClose();
        }
        this.repopulateSlots(gui, pMouseX, pMouseY, pPartialTick);
        super.render(gui, pMouseX, pMouseY, pPartialTick);
        List tooltipFromItem = Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)this.backpack.toStack());
        int width = 0;
        for (Component line : tooltipFromItem) {
            int i = this.font.width((FormattedText)line);
            if (i <= width) continue;
            width = i;
        }
        gui.renderTooltip(this.font, tooltipFromItem, Optional.empty(), this.leftPos - (width += 56) + 19, this.traitY - 12 * tooltipFromItem.size() + 9);
        this.renderTooltip(gui, pMouseX, pMouseY);
    }

    protected abstract void repopulateSlots(GuiGraphics var1, int var2, int var3, float var4);

    public void addSlot(TraitSlot widget) {
        this.slots.add(widget);
    }

    public void clearSlots() {
        this.slots.clear();
    }

    public ItemStack getCarried() {
        return ((InventoryMenu)this.menu).getCarried();
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected boolean hasClickedOutside(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (pMouseX > (double)(this.traitX - this.traitW) && pMouseY > (double)this.traitY && pMouseX < (double)this.traitX && pMouseY < (double)(this.traitY + this.traitH)) {
            return false;
        }
        return super.hasClickedOutside(pMouseX, pMouseY, pGuiLeft, pGuiTop, pMouseButton);
    }

    protected void renderBg(GuiGraphics gui, float v, int pMouseX, int pMouseY) {
        int left = this.leftPos;
        int top = this.topPos;
        gui.blit(INVENTORY_LOCATION, left, top, 0, 0, this.imageWidth, this.imageHeight);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)gui, (int)(left + 26), (int)(top + 8), (int)(left + 75), (int)(top + 78), (int)30, (float)0.0625f, (float)pMouseX, (float)pMouseY, (LivingEntity)this.minecraft.player);
        CommonClient.renderSlots(gui, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.minecraft.player);
    }

    public abstract class TraitSlot
    extends AbstractWidget {
        protected final int index;

        public TraitSlot(int pX, int pY, int index) {
            super(pX, pY, 18, 18, (Component)Component.empty());
            this.index = index;
        }

        public abstract ItemStack getItem();

        public boolean mouseClicked(double pMouseX, double pMouseY, int button) {
            if (this.active && this.visible && this.clicked(pMouseX, pMouseY)) {
                LocalPlayer player = ((BackpackScreen)BackpackScreen.this).minecraft.player;
                TinyClickType clickType = BackpackScreen.getClickType(BackpackScreen.this.minecraft, button, (Player)player);
                final AbstractContainerMenu menu = player.containerMenu;
                SlotAccess carriedAccess = new SlotAccess(){

                    public ItemStack get() {
                        return menu.getCarried();
                    }

                    public boolean set(ItemStack p_150452_) {
                        menu.setCarried(p_150452_);
                        return true;
                    }
                };
                BackpackScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
                return true;
            }
            return false;
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void playDownSound(SoundManager pHandler) {
        }

        public void hotbarClick(int hotbarSlot) {
            LocalPlayer player = ((BackpackScreen)BackpackScreen.this).minecraft.player;
            final AbstractContainerMenu menu = player.containerMenu;
            SlotAccess carriedAccess = new SlotAccess(){

                public ItemStack get() {
                    return menu.getCarried();
                }

                public boolean set(ItemStack p_150452_) {
                    menu.setCarried(p_150452_);
                    return true;
                }
            };
            TinyClickType clickType = TinyClickType.getHotbar(hotbarSlot);
            BackpackScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
        }

        public void dropItem() {
            LocalPlayer player = ((BackpackScreen)BackpackScreen.this).minecraft.player;
            final AbstractContainerMenu menu = player.containerMenu;
            SlotAccess carriedAccess = new SlotAccess(){

                public ItemStack get() {
                    return menu.getCarried();
                }

                public boolean set(ItemStack p_150452_) {
                    menu.setCarried(p_150452_);
                    return true;
                }
            };
            BackpackScreen.this.tinyMenuClick(this.index, TinyClickType.DROP, carriedAccess, player);
        }
    }
}

