/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

import com.beansgalaxy.backpacks.items.AbstractBurlapSackEntity;
import com.beansgalaxy.backpacks.items.ModBlocks;
import com.beansgalaxy.backpacks.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BurlapSackMenu
extends AbstractContainerMenu {
    public final AbstractBurlapSackEntity entity;
    private final Level level;

    public BurlapSackMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(buf.readBlockPos()));
    }

    public BurlapSackMenu(int containerId, Inventory inventory, BlockEntity entity) {
        super(Services.PLATFORM.getBurlapSackMenuType(), containerId);
        this.entity = (AbstractBurlapSackEntity)entity;
        this.level = inventory.player.level();
        this.addPlayerHotbar(inventory);
        this.addPlayerInventory(inventory);
        this.addBurlapSackSlots();
    }

    public BurlapSackMenu(int containerId, Inventory inventory, BlockPos pos) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(pos));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        ItemStack clicked = slot.getItem();
        if (index > 35) {
            if (this.tryToInventory(clicked)) {
                this.entity.setChanged();
                return ItemStack.EMPTY;
            }
        } else {
            int space = this.entity.getRemainingSpace(clicked);
            if (space == 0) {
                return ItemStack.EMPTY;
            }
            for (ItemStack stack : this.entity.getItemStacks()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)clicked)) continue;
                int count = Math.min(clicked.getCount(), space);
                stack.grow(count);
                clicked.shrink(count);
                this.entity.setChanged();
                return ItemStack.EMPTY;
            }
            this.entity.addItem(clicked);
            this.entity.setChanged();
        }
        return ItemStack.EMPTY;
    }

    private boolean tryToInventory(ItemStack clicked) {
        int stopCount = Math.min(clicked.getCount(), clicked.getMaxStackSize());
        if ((stopCount = this.tryStack(8, 0, clicked, stopCount)) == 0) {
            return true;
        }
        if ((stopCount = this.tryStack(35, 8, clicked, stopCount)) == 0) {
            return true;
        }
        if ((stopCount = this.findEmpty(8, 0, clicked, stopCount)) == 0) {
            return true;
        }
        return (stopCount = this.findEmpty(35, 8, clicked, stopCount)) == 0;
    }

    private int tryStack(int start, int low, ItemStack clicked, int stopCount) {
        for (int i = start; i > low; --i) {
            int maxStackSize;
            int count;
            Slot iSlot = (Slot)this.slots.get(i);
            ItemStack stack = iSlot.getItem();
            if (stack.isEmpty() || (count = stack.getCount()) >= (maxStackSize = iSlot.getMaxStackSize(stack)) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)clicked)) continue;
            int min = Math.min(maxStackSize - count, stopCount);
            stack.grow(min);
            clicked.shrink(min);
            stopCount -= min;
            iSlot.setChanged();
            if (!clicked.isEmpty()) continue;
            this.entity.getItemStacks().remove(clicked);
            return 0;
        }
        return stopCount;
    }

    private int findEmpty(int start, int low, ItemStack clicked, int endCount) {
        for (int i = start; i > low; --i) {
            Slot iSlot = (Slot)this.slots.get(i);
            if (!iSlot.getItem().isEmpty()) continue;
            int maxStackSize = iSlot.getMaxStackSize(clicked);
            int toMove = Math.min(endCount, maxStackSize);
            iSlot.setByPlayer(clicked.copyWithCount(toMove));
            clicked.shrink(toMove);
            endCount -= toMove;
            if (!clicked.isEmpty()) continue;
            this.entity.getItemStacks().remove(clicked);
            return 0;
        }
        return endCount;
    }

    public boolean stillValid(Player pPlayer) {
        return BurlapSackMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.entity.getBlockPos()), (Player)pPlayer, (Block)ModBlocks.BURLAP_SACK.get());
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 162));
        }
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 104 + i * 18));
            }
        }
    }

    private void addBurlapSackSlots() {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new BurlapSackSlot(x + y * 9, 8 + x * 18, 72 + y * -18));
            }
        }
    }

    public void clicked(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (ClickType.SWAP.equals((Object)pClickType)) {
            return;
        }
        super.clicked(pSlotId, pButton, pClickType, pPlayer);
    }

    class BurlapSackSlot
    extends Slot {
        public BurlapSackSlot(int pSlot, int pX, int pY) {
            super((Container)BurlapSackMenu.this.entity, pSlot, pX, pY);
        }

        public void setByPlayer(ItemStack pStack) {
            BurlapSackMenu.this.entity.addItem(this.getContainerSlot(), pStack);
            this.setChanged();
        }

        public void setByPlayer(ItemStack pNewStack, ItemStack pOldStack) {
            this.setByPlayer(pNewStack);
        }

        public boolean isHighlightable() {
            return BurlapSackMenu.this.entity.getSize() > this.getContainerSlot();
        }

        public ItemStack safeInsert(ItemStack stack, int increment) {
            if (!stack.isEmpty() && this.mayPlace(stack)) {
                BurlapSackMenu.this.entity.addItem(this.getContainerSlot(), stack, increment);
            }
            this.setChanged();
            return stack;
        }

        public boolean mayPlace(ItemStack pStack) {
            int space = BurlapSackMenu.this.entity.getRemainingSpace(pStack);
            return space >= pStack.getCount();
        }

        public void setChanged() {
            super.setChanged();
            BurlapSackMenu.this.entity.setChanged();
        }
    }
}

