/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class TinyTraitScreen
extends Screen {
    protected final List<TinyTraitSlot> slots = new ArrayList<TinyTraitSlot>();
    protected int leftPos;
    private int topPos;

    protected TinyTraitScreen(Component pTitle) {
        super(pTitle);
    }

    protected abstract void tinyHotbarClick(TinyClickType var1, InventoryMenu var2, LocalPlayer var3, int var4);

    protected abstract void tinyMenuClick(int var1, TinyClickType var2, SlotAccess var3, LocalPlayer var4);

    protected static TinyClickType getClickType(Minecraft minecraft, int button, Player player) {
        boolean eitherShiftDown;
        BackData backData = BackData.get(player);
        if (backData.isMenuKeyDown() && backData.getTinySlot() == -1) {
            return TinyClickType.ACTION;
        }
        boolean bl = eitherShiftDown = InputConstants.isKeyDown((long)minecraft.getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)minecraft.getWindow().getWindow(), (int)344);
        if (eitherShiftDown) {
            return TinyClickType.SHIFT;
        }
        if (button == 1) {
            return TinyClickType.RIGHT;
        }
        return TinyClickType.LEFT;
    }

    public void initHotBarSlots() {
        Window window = this.minecraft.getWindow();
        int scaledHeight = window.getGuiScaledHeight();
        int scaledWidth = window.getGuiScaledWidth();
        for (int i = 0; i < 9; ++i) {
            int x = scaledWidth / 2 + i * 20 - 89;
            HotBarSlot slot = new HotBarSlot(x, scaledHeight - 20, i);
            this.addRenderableWidget((GuiEventListener)slot);
        }
    }

    public void render(GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        ItemStack carried = this.getCarried();
        CommonClient.renderItem(this.minecraft, gui, carried, pMouseX, pMouseY, 300, false);
        CommonClient.renderItemDecorations(gui, this.font, carried, pMouseX, pMouseY, 300);
        super.render(gui, pMouseX, pMouseY, pPartialTick);
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        KeyMapping[] hotbarSlots = this.minecraft.options.keyHotbarSlots;
        for (int i = 0; i < hotbarSlots.length; ++i) {
            KeyMapping hotbarSlot = hotbarSlots[i];
            if (!hotbarSlot.matches(pKeyCode, pScanCode)) continue;
            TinyTraitSlot slot = this.getHoveredSlot();
            if (slot != null) {
                slot.hotbarClick(i);
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public ItemStack getCarried() {
        return this.minecraft.player.containerMenu.getCarried();
    }

    @Nullable
    private TinyTraitSlot getHoveredSlot() {
        MouseHandler mouseHandler = this.minecraft.mouseHandler;
        double x = mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        double y = mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
        for (TinyTraitSlot slot : this.slots) {
            if (!slot.isMouseOver(x, y)) continue;
            return slot;
        }
        return null;
    }

    public void onClose() {
        this.minecraft.setScreen(null);
    }

    public void addSlot(TinyTraitSlot widget) {
        this.slots.add(widget);
    }

    public void clearSlots() {
        this.slots.clear();
    }

    public int topPosOffset() {
        return 0;
    }

    public int getTopPos() {
        return this.topPos + this.topPosOffset();
    }

    public void setTopPos(int topPos) {
        this.topPos = topPos;
    }

    public class HotBarSlot
    extends AbstractWidget {
        private final int index;

        public HotBarSlot(int pX, int pY, int index) {
            super(pX, pY, 18, 18, (Component)Component.empty());
            this.index = index;
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int button) {
            if (this.active && this.visible && this.clicked(pMouseX, pMouseY)) {
                LocalPlayer player = ((TinyTraitScreen)TinyTraitScreen.this).minecraft.player;
                InventoryMenu menu = player.inventoryMenu;
                TinyClickType clickType = TinyTraitScreen.getClickType(TinyTraitScreen.this.minecraft, button, (Player)player);
                TinyTraitScreen.this.tinyHotbarClick(clickType, menu, player, this.index);
                return true;
            }
            return false;
        }

        protected void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
            if (this.isHovered()) {
                int x = this.getX() + 9;
                int y = this.getY() + 9;
                gui.fill(x - 8, y - 8, x + 8, y + 8, 100, -1996488705);
                if (TinyTraitScreen.this.getCarried().isEmpty()) {
                    Inventory inventory = ((TinyTraitScreen)TinyTraitScreen.this).minecraft.player.getInventory();
                    ItemStack stack = (ItemStack)inventory.items.get(this.index);
                    if (!stack.isEmpty()) {
                        List tooltipFromItem = Screen.getTooltipFromItem((Minecraft)TinyTraitScreen.this.minecraft, (ItemStack)stack);
                        Optional tooltipImage = stack.getTooltipImage();
                        gui.renderTooltip(TinyTraitScreen.this.font, tooltipFromItem, tooltipImage, mouseX, mouseY);
                    }
                }
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }

    public abstract class TinyTraitSlot
    extends AbstractWidget {
        protected final int index;

        public TinyTraitSlot(int pX, int pY, int index) {
            super(pX, pY, 18, 18, (Component)Component.empty());
            this.index = index;
        }

        public abstract ItemStack getItem();

        public boolean mouseClicked(double pMouseX, double pMouseY, int button) {
            if (this.active && this.visible && this.clicked(pMouseX, pMouseY)) {
                LocalPlayer player = ((TinyTraitScreen)TinyTraitScreen.this).minecraft.player;
                TinyClickType clickType = TinyTraitScreen.getClickType(TinyTraitScreen.this.minecraft, button, (Player)player);
                final AbstractContainerMenu menu = player.containerMenu;
                SlotAccess carriedAccess = new SlotAccess(){

                    public ItemStack get() {
                        return menu.getCarried();
                    }

                    public boolean set(ItemStack p_150452_) {
                        menu.setCarried(p_150452_);
                        return true;
                    }
                };
                TinyTraitScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
                return true;
            }
            return false;
        }

        public void hotbarClick(int hotbarSlot) {
            LocalPlayer player = ((TinyTraitScreen)TinyTraitScreen.this).minecraft.player;
            final AbstractContainerMenu menu = player.containerMenu;
            SlotAccess carriedAccess = new SlotAccess(){

                public ItemStack get() {
                    return menu.getCarried();
                }

                public boolean set(ItemStack p_150452_) {
                    menu.setCarried(p_150452_);
                    return true;
                }
            };
            TinyClickType clickType = TinyClickType.getHotbar(hotbarSlot);
            TinyTraitScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void playDownSound(SoundManager pHandler) {
        }
    }
}

