/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.traits.IClientTraits;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.bundle.BundleMenu;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class TraitMenu<T extends GenericTraits> {
    protected final Minecraft minecraft;
    public final Slot slot;
    public final ComponentHolder holder;
    public final T traits;
    protected final int slotX;
    protected final int slotY;
    public final long timeOpened;
    private final int screenWidth;
    private final int screenHeight;
    protected double leftPos;
    protected double topPos;
    protected boolean isFocused = false;

    public TraitMenu(Minecraft minecraft, int screenLeft, int screenTop, int screenHeight, int screenWidth, Slot slot, ComponentHolder holder, T traits) {
        this(minecraft, slot, holder, traits, screenLeft + slot.x, screenTop + slot.y, screenHeight, screenWidth);
    }

    public TraitMenu(Minecraft minecraft, Slot slot, ComponentHolder holder, T traits, int slotX, int slotY, int screenHeight, int screenWidth) {
        this.minecraft = minecraft;
        this.slot = slot;
        this.holder = holder;
        this.traits = traits;
        this.slotX = slotX;
        this.slotY = slotY;
        this.leftPos = slotX + 14;
        this.topPos = slotY - 2;
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
        this.timeOpened = Util.getMillis();
    }

    int topPos() {
        return (int)this.topPos;
    }

    int leftPos() {
        return (int)this.leftPos;
    }

    @Nullable
    public static TraitMenu<?> create(Minecraft minecraft, int leftPos, int topPos, int imageHeight, int imageWidth, Slot slot) {
        ComponentHolder holder;
        GenericTraits traits;
        if (slot == null) {
            return null;
        }
        ItemStack stack = slot.getItem();
        Optional<GenericTraits> optional = Traits.get(stack);
        if (optional.isEmpty()) {
            Optional<EnderTraits> oEnderTraits = EnderTraits.get(stack);
            if (oEnderTraits.isEmpty()) {
                return null;
            }
            EnderTraits enderTraits = oEnderTraits.get();
            traits = enderTraits.getTrait((Level)Minecraft.getInstance().level);
            holder = enderTraits;
        } else {
            traits = optional.get();
            holder = ComponentHolder.of(slot);
        }
        IClientTraits<GenericTraits> client = traits.client();
        return client.createTooltip(minecraft, leftPos, topPos, imageHeight, imageWidth, slot, holder, traits);
    }

    public void render(AbstractContainerScreen<?> screen, GuiGraphics gui, int mouseX, int mouseY) {
        int y = this.slot.y;
        int x = this.slot.x;
        if (this.isFocused) {
            ItemStack stack = this.slot.getItem();
            BundleMenu.renderTooltipBackground(gui, x + 1, y + 1, 14, 14, 300);
            CommonClient.renderItem(this.minecraft, gui, stack, x + 8, y + 8, 350, false);
            CommonClient.renderItemDecorations(gui, this.minecraft.font, stack, x + 8, y + 8, 350);
        }
        int xMove = this.slot.x - this.slotX + this.leftPos();
        int yMove = this.slot.y - this.slotY + this.topPos();
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((float)xMove, (float)yMove, 350.0f);
        this.menuRender(screen, gui, mouseX - this.leftPos(), mouseY - this.topPos());
        pose.popPose();
    }

    public boolean isHovering(int mouseX, int mouseY) {
        return this.isHoveringSlot(mouseX, mouseY) || this.isHoveringMenu(mouseX, mouseY);
    }

    public boolean isHoveringSlot(int mouseX, int mouseY) {
        if (mouseX < this.slotX - 1) {
            return false;
        }
        return mouseY >= this.slotY - 1 && mouseY <= this.slotY + 16 && mouseX <= this.slotX + 18;
    }

    public void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        this.menuClicked(mouseX - (double)this.leftPos(), mouseY - (double)this.topPos(), button, cir);
    }

    public void setFocus(boolean isFocused) {
        this.isFocused = isFocused;
    }

    protected void menuRender(AbstractContainerScreen<?> screen, GuiGraphics gui, int mouseX, int mouseY) {
        String name = this.traits.getClass().getSimpleName();
        MutableComponent component = Component.literal((String)name);
        gui.renderComponentTooltip(this.minecraft.font, List.of(component), 0, this.getHeight());
    }

    public void menuClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
    }

    private boolean isHoveringMenu(int mouseX, int mouseY) {
        if ((mouseX -= this.leftPos()) < 0 || (mouseY -= this.topPos()) < 0) {
            return false;
        }
        return this.getWidth() - 4 > mouseX && this.getHeight() > mouseY;
    }

    protected int getWidth() {
        String name = this.traits.getClass().getSimpleName();
        MutableComponent component = Component.literal((String)name);
        int width = this.minecraft.font.width((FormattedText)component);
        return width + 16;
    }

    protected int getHeight() {
        return 16;
    }

    public void dropHoveredItem(CallbackInfoReturnable<Boolean> cir) {
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, CallbackInfoReturnable<Boolean> cir) {
    }
}

