/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits;

import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.Nullable;

public abstract class ITraitData<T> {
    public static final TraitDataComponentType<List<ItemStack>> ITEM_STACKS = ITraitData.register("data_item_list", Traits.STACKS_CODEC, ItemStack.LIST_STREAM_CODEC, ItemList::new);
    public static final TraitDataComponentType<List<ItemStack>> NON_EDIBLES = ITraitData.register("data_non_edible", ItemStack.CODEC.listOf(), ItemStack.LIST_STREAM_CODEC, NonEdibles::new);
    public static final DataComponentType<ItemContainerContents> CHEST = Traits.register("data_chest", ItemContainerContents.CODEC, ItemContainerContents.STREAM_CODEC);
    public static final TraitDataComponentType<ItemStack> SOLO_STACK = ITraitData.register("data_solo_item", ItemStack.OPTIONAL_CODEC, ItemStack.OPTIONAL_STREAM_CODEC, SoloItem::new);
    public static final TraitDataComponentType<Integer> AMOUNT = ITraitData.register("data_amount", ExtraCodecs.NON_NEGATIVE_INT, ByteBufCodecs.INT, Amount::new);
    public static final DataComponentType<SlotSelection> SLOT_SELECTION = Traits.register("data_selection", Codec.unit(SlotSelection::new), SlotSelection.STREAM_CODEC);
    public static final DataComponentType<UtilityComponent> UTILITIES = Traits.register("utility_slots", UtilityComponent.CODEC, UtilityComponent.STREAM_CODEC);
    protected T value = null;
    boolean isDirty = false;
    protected final ComponentHolder holder;

    public static void register() {
    }

    public static <T> TraitDataComponentType<T> register(String name, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, Function<ComponentHolder, ITraitData<T>> getData) {
        TraitDataComponentType<T> type = new TraitDataComponentType<T>(codec, streamCodec, getData);
        Services.PLATFORM.register(name, type);
        return type;
    }

    @Nullable
    public T remove() {
        return this.holder().remove(this.type());
    }

    public abstract DataComponentType<T> type();

    public abstract boolean isEmpty(T var1);

    public boolean isEmpty() {
        if (this.value != null) {
            return this.isEmpty(this.value);
        }
        T data = this.holder().get(this.type());
        return data == null || this.isEmpty(data);
    }

    protected ITraitData(ComponentHolder holder) {
        this.holder = holder;
    }

    public ComponentHolder holder() {
        return this.holder;
    }

    public abstract T get();

    public void markDirty() {
        this.isDirty = true;
    }

    public void push() {
        if (this.isEmpty()) {
            this.holder().remove(this.type());
        } else if (this.isDirty) {
            this.holder().set(this.type(), this.value);
        }
    }

    public ITraitData<T> set(T value) {
        this.markDirty();
        this.value = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ITraitData that = (ITraitData)obj;
        return Objects.equals(this.holder(), that.holder()) && Objects.equals(this.value, that.value);
    }

    public static class TraitDataComponentType<T>
    implements DataComponentType<T> {
        private final Codec<T> codec;
        private final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;
        private final Function<ComponentHolder, ITraitData<T>> getData;

        public TraitDataComponentType(Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec, Function<ComponentHolder, ITraitData<T>> getData) {
            this.codec = codec;
            this.streamCodec = streamCodec;
            this.getData = getData;
        }

        @Nullable
        public Codec<T> codec() {
            return this.codec;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }

        public ITraitData<T> get(ComponentHolder holder) {
            return this.getData.apply(holder);
        }
    }

    static class Amount
    extends ITraitData<Integer> {
        public Amount(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public DataComponentType<Integer> type() {
            return AMOUNT;
        }

        @Override
        public boolean isEmpty() {
            if (this.value != null) {
                this.markDirty();
                return (Integer)this.value == 0;
            }
            Integer amount = this.holder.get(this.type());
            return amount == null || amount == 0;
        }

        @Override
        public boolean isEmpty(Integer data) {
            return data == 0;
        }

        @Override
        public Integer get() {
            if (this.value == null) {
                this.markDirty();
                Integer t = this.holder().get(this.type());
                this.value = Objects.requireNonNullElse(t, 0);
            }
            return (Integer)this.value;
        }
    }

    static class NonEdibles
    extends ItemList {
        public NonEdibles(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public DataComponentType<List<ItemStack>> type() {
            return NON_EDIBLES;
        }
    }

    static class ItemList
    extends ITraitData<List<ItemStack>> {
        public ItemList(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public DataComponentType<List<ItemStack>> type() {
            return ITEM_STACKS;
        }

        @Override
        public List<ItemStack> get() {
            if (this.value == null) {
                this.markDirty();
                List<ItemStack> t = this.holder().get(this.type());
                this.value = t == null ? new ArrayList() : new ArrayList<ItemStack>(t);
            }
            return (List)this.value;
        }

        @Override
        public void push() {
            List<ItemStack> stacks;
            List<ItemStack> list = stacks = this.value == null ? this.holder.get(this.type()) : (List<ItemStack>)this.value;
            if (stacks == null) {
                return;
            }
            this.value = stacks.stream().filter(itemStack -> !itemStack.isEmpty()).toList();
            if (((List)this.value).isEmpty()) {
                this.holder.remove(this.type());
            } else if (this.isDirty) {
                this.holder.set(this.type(), (List)this.value);
            }
        }

        @Override
        public boolean isEmpty(List<ItemStack> data) {
            return data.isEmpty();
        }
    }

    static class SoloItem
    extends ITraitData<ItemStack> {
        public SoloItem(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public DataComponentType<ItemStack> type() {
            return SOLO_STACK;
        }

        @Override
        public ItemStack get() {
            if (this.value == null) {
                this.markDirty();
                ItemStack t = this.holder().get(this.type());
                this.value = Objects.requireNonNullElse(t, ItemStack.EMPTY);
            }
            return (ItemStack)this.value;
        }

        @Override
        public boolean isEmpty(ItemStack data) {
            return data.isEmpty();
        }
    }
}

