/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits;

import com.beansgalaxy.backpacks.access.EquipmentSlotAccess;
import com.beansgalaxy.backpacks.components.BulkComponent;
import com.beansgalaxy.backpacks.components.DisplayComponent;
import com.beansgalaxy.backpacks.components.FilterComponent;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.components.ender.EmptyEnderItem;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.alchemy.AlchemyCodecs;
import com.beansgalaxy.backpacks.traits.alchemy.AlchemyTraits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackCodecs;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.bundle.BundleCodecs;
import com.beansgalaxy.backpacks.traits.bundle.BundleTraits;
import com.beansgalaxy.backpacks.traits.chest.ChestCodecs;
import com.beansgalaxy.backpacks.traits.chest.ChestTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxCodecs;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxTraits;
import com.beansgalaxy.backpacks.traits.quiver.QuiverCodecs;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public interface Traits {
    public static final DataComponentType<BulkComponent> BULK = Traits.register("bulk", BulkComponent.CODEC, BulkComponent.STREAM_CODEC);
    public static final DataComponentType<DisplayComponent> DISPLAY = Traits.register("display", DisplayComponent.CODEC, DisplayComponent.STREAM_CODEC);
    public static final DataComponentType<FilterComponent> FILTER = Traits.register("filter", FilterComponent.CODEC, FilterComponent.STREAM_CODEC);
    public static final DataComponentType<ReferenceTrait> REFERENCE = Traits.register("reference", ReferenceTrait.CODEC, ReferenceTrait.STREAM_CODEC);
    public static final DataComponentType<EnderTraits> ENDER = Traits.register("ender", EnderTraits.CODEC, EnderTraits.STREAM_CODEC);
    public static final DataComponentType<EmptyEnderItem.UnboundEnderTraits> EMPTY_ENDER = Traits.register("empty_ender", EmptyEnderItem.CODEC, EmptyEnderItem.STREAM_CODEC);
    public static final TraitComponentKind<BundleTraits> BUNDLE = TraitComponentKind.registerBundleLike("bundle", BundleCodecs.INSTANCE);
    public static final TraitComponentKind<LunchBoxTraits> LUNCH_BOX = TraitComponentKind.registerBundleLike("lunch", LunchBoxCodecs.INSTANCE);
    public static final TraitComponentKind<QuiverTraits> QUIVER = TraitComponentKind.registerBundleLike("quiver", QuiverCodecs.INSTANCE);
    public static final TraitComponentKind<AlchemyTraits> ALCHEMY = TraitComponentKind.registerBundleLike("alchemy", AlchemyCodecs.INSTANCE);
    public static final DataComponentType<Byte> UTILITIES = Traits.register("utilities", UtilityComponent.SIZE_CODEC, ByteBufCodecs.BYTE);
    public static final TraitComponentKind<ChestTraits> CHEST = TraitComponentKind.registerBundleLike("chest", ChestCodecs.INSTANCE);
    public static final TraitComponentKind<BackpackTraits> BACKPACK = TraitComponentKind.registerBundleLike("backpack", BackpackCodecs.INSTANCE);
    public static final Codec<List<ItemStack>> STACKS_CODEC = Codec.list((Codec)RecordCodecBuilder.create(in -> in.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf("count").forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)in, ItemStack::new)));

    public static <T> DataComponentType<T> register(String name, Codec<T> codec, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        DataComponentType.Builder builder = DataComponentType.builder();
        DataComponentType type = builder.persistent(codec).networkSynchronized(streamCodec).cacheEncoding().build();
        return Services.PLATFORM.register(name, type);
    }

    public static Optional<GenericTraits> get(ItemStack stack) {
        return stack.isEmpty() ? Optional.empty() : Traits.get(ComponentHolder.of(stack));
    }

    public static Optional<GenericTraits> get(ComponentHolder stack) {
        for (TraitComponentKind<? extends GenericTraits> type : TraitComponentKind.TRAITS) {
            GenericTraits traits = stack.get(type);
            if (traits == null) continue;
            return Optional.of(traits);
        }
        ReferenceTrait reference = stack.get(REFERENCE);
        if (reference != null) {
            return reference.getTrait();
        }
        return Optional.empty();
    }

    public static void runIfPresent(ItemStack stack, Consumer<GenericTraits> runnable) {
        if (!stack.isEmpty()) {
            Optional<GenericTraits> traits = Traits.get(stack);
            traits.ifPresent(runnable);
        }
    }

    public static void runIfPresent(ItemStack stack, Consumer<GenericTraits> runnable, Runnable orElse) {
        if (!stack.isEmpty()) {
            Optional<GenericTraits> traits = Traits.get(stack);
            traits.ifPresentOrElse(runnable, orElse);
        } else {
            orElse.run();
        }
    }

    public static boolean testIfPresent(ItemStack stack, Predicate<GenericTraits> predicate) {
        if (stack.isEmpty()) {
            return false;
        }
        return Traits.testIfPresent(ComponentHolder.of(stack), predicate);
    }

    public static boolean testIfPresent(ComponentHolder stack, Predicate<GenericTraits> predicate) {
        Optional<GenericTraits> genericTraits = Traits.get(stack);
        if (genericTraits.isEmpty()) {
            return false;
        }
        GenericTraits traits = genericTraits.get();
        return predicate.test(traits);
    }

    public static void runIfEquipped(Player player, BiPredicate<GenericTraits, EquipmentSlot> runnable) {
        NonNullList slots = player.inventoryMenu.slots;
        for (int i = slots.size() - 1; i > 4; --i) {
            Optional<GenericTraits> traits;
            Slot slot = (Slot)slots.get(i);
            if (!(slot instanceof EquipmentSlotAccess)) continue;
            EquipmentSlotAccess access = (EquipmentSlotAccess)slot;
            ItemStack stack = slot.getItem();
            if (stack.isEmpty() || (traits = Traits.get(stack)).isEmpty() || !runnable.test(traits.get(), access.getSlot())) continue;
            return;
        }
    }

    public static Fraction getWeight(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return Fraction.ZERO;
        }
        Fraction fraction = Fraction.ZERO;
        for (ItemStack stack : stacks) {
            Fraction stackWeight = Traits.getStackWeight(stack);
            fraction = fraction.add(stackWeight);
        }
        return fraction;
    }

    public static Fraction getWeight(List<ItemStack> stacks, int size) {
        return Traits.getWeight(stacks).multiplyBy(Fraction.getFraction((int)1, (int)size));
    }

    public static Fraction getStackWeight(ItemStack stack) {
        return Fraction.getFraction((int)stack.getCount(), (int)stack.getMaxStackSize());
    }

    public static Fraction getItemWeight(ItemStack stack) {
        return Fraction.getFraction((int)1, (int)stack.getMaxStackSize());
    }

    public static void register() {
    }

    @Nullable
    public static <T extends GenericTraits> T get(ComponentHolder backpack, TraitComponentKind<T> kind) {
        GenericTraits genericTraits;
        Optional<GenericTraits> reference;
        GenericTraits traits = (GenericTraits)backpack.get(kind);
        if (traits != null) {
            return (T)traits;
        }
        ReferenceTrait referenceTrait = backpack.get(REFERENCE);
        if (referenceTrait != null && (reference = referenceTrait.getTrait()).isPresent() && kind.equals((genericTraits = reference.get()).kind())) {
            return (T)genericTraits;
        }
        return null;
    }

    @Nullable
    public static <T extends GenericTraits> T get(ComponentHolder backpack, TraitComponentKind<T>[] kinds) {
        for (TraitComponentKind<T> kind : kinds) {
            GenericTraits traits = (GenericTraits)backpack.get(kind);
            if (traits == null) continue;
            return (T)traits;
        }
        ReferenceTrait referenceTrait = backpack.get(REFERENCE);
        if (referenceTrait == null) {
            return null;
        }
        Optional<GenericTraits> reference = referenceTrait.getTrait();
        if (reference.isEmpty()) {
            return null;
        }
        GenericTraits genericTraits = reference.get();
        for (TraitComponentKind<T> kind : kinds) {
            if (!kind.equals(genericTraits.kind())) continue;
            return (T)genericTraits;
        }
        return null;
    }
}

