/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.abstract_traits;

import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.DraggingContainer;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IDraggingTrait {
    public static final TraitComponentKind<? extends IDraggingTrait>[] TRAITS = new TraitComponentKind[]{Traits.BUNDLE, Traits.LUNCH_BOX, Traits.ALCHEMY, Traits.QUIVER, Traits.CHEST};

    @Nullable
    public static IDraggingTrait get(ComponentHolder backpack) {
        GenericTraits genericTraits;
        for (TraitComponentKind<? extends IDraggingTrait> kind : TRAITS) {
            IDraggingTrait traits = backpack.get(kind);
            if (traits == null) continue;
            return traits;
        }
        ReferenceTrait referenceTrait = backpack.get(Traits.REFERENCE);
        if (referenceTrait == null) {
            return null;
        }
        Optional<GenericTraits> reference = referenceTrait.getTrait();
        if (!reference.isEmpty() && (genericTraits = reference.get()) instanceof IDraggingTrait) {
            IDraggingTrait draggingTrait = (IDraggingTrait)((Object)genericTraits);
            return draggingTrait;
        }
        return null;
    }

    public static void runIfPresent(ItemStack backpack, Level level, BiConsumer<IDraggingTrait, ComponentHolder> consumer) {
        EnderTraits enderTraits;
        GenericTraits trait;
        ComponentHolder holder = ComponentHolder.of(backpack);
        IDraggingTrait draggingTrait = IDraggingTrait.get(holder);
        if (draggingTrait != null) {
            consumer.accept(draggingTrait, holder);
            return;
        }
        Optional<EnderTraits> optionalEnder = EnderTraits.get(backpack);
        if (optionalEnder.isPresent() && (trait = (enderTraits = optionalEnder.get()).getTrait(level)) instanceof IDraggingTrait) {
            IDraggingTrait storageTraits = (IDraggingTrait)((Object)trait);
            consumer.accept(storageTraits, enderTraits);
        }
    }

    default public void clickSlot(DraggingContainer drag, Player player, ComponentHolder holder) {
        Slot slot = drag.firstSlot;
        if (drag.isPickup) {
            ItemStack stack = slot.getItem();
            boolean mayPickup = slot.mayPickup(player);
            boolean hasItem = slot.hasItem();
            boolean canFit = this.canItemFit(holder, stack);
            boolean isFull = this.isFull(holder);
            if (mayPickup && hasItem && canFit && !isFull) {
                drag.allSlots.put(drag.firstSlot, stack.copyWithCount(1));
                drag.slotClicked(slot, slot.index, 1, ClickType.PICKUP);
            }
        } else {
            ItemStack itemStack = this.getFirst(holder);
            if (itemStack != null && !slot.hasItem() && AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)itemStack, (boolean)true) && slot.mayPlace(itemStack)) {
                drag.allSlots.put(slot, ItemStack.EMPTY);
                drag.slotClicked(slot, slot.index, 1, ClickType.PICKUP);
            }
        }
    }

    public ItemStack getFirst(ComponentHolder var1);

    public boolean isFull(ComponentHolder var1);

    public boolean canItemFit(ComponentHolder var1, ItemStack var2);
}

