/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.abstract_traits;

import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.network.serverbound.SyncSelectedSlot;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.IMutableSelectionTrait;
import com.beansgalaxy.backpacks.traits.alchemy.AlchemyTraits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ISlotSelectorTrait {
    public static final TraitComponentKind<? extends ISlotSelectorTrait>[] TRAITS = new TraitComponentKind[]{Traits.LUNCH_BOX, Traits.ALCHEMY, Traits.QUIVER};

    public static ISlotSelectorTrait get(ItemStack stack) {
        GenericTraits genericTraits;
        for (TraitComponentKind<? extends ISlotSelectorTrait> traits : TRAITS) {
            ISlotSelectorTrait trait = (ISlotSelectorTrait)stack.get(traits);
            if (trait == null) continue;
            return trait;
        }
        ReferenceTrait reference = (ReferenceTrait)stack.get(Traits.REFERENCE);
        if (reference == null) {
            return null;
        }
        Optional<GenericTraits> optional = reference.getTrait();
        if (optional.isPresent() && (genericTraits = optional.get()) instanceof ISlotSelectorTrait) {
            ISlotSelectorTrait trait = (ISlotSelectorTrait)((Object)genericTraits);
            return trait;
        }
        return null;
    }

    public static BundleLikeTraits getFoodStuffsTrait(ItemStack stack) {
        LunchBoxTraits lunch = (LunchBoxTraits)stack.get(Traits.LUNCH_BOX);
        if (lunch != null) {
            return lunch;
        }
        AlchemyTraits alchemy = (AlchemyTraits)stack.get(Traits.ALCHEMY);
        if (alchemy != null) {
            return alchemy;
        }
        ReferenceTrait reference = (ReferenceTrait)stack.get(Traits.REFERENCE);
        if (reference == null) {
            return null;
        }
        Optional<GenericTraits> optional = reference.getTrait();
        if (optional.isEmpty()) {
            return null;
        }
        GenericTraits genericTraits = optional.get();
        if (genericTraits instanceof LunchBoxTraits) {
            LunchBoxTraits lunchRef = (LunchBoxTraits)genericTraits;
            return lunchRef;
        }
        genericTraits = optional.get();
        if (genericTraits instanceof AlchemyTraits) {
            AlchemyTraits alchemyRef = (AlchemyTraits)genericTraits;
            return alchemyRef;
        }
        return null;
    }

    @Nullable
    public static ItemStack getFoodstuffsSelection(ItemStack lunchBox, Player player) {
        BundleLikeTraits traits = ISlotSelectorTrait.getFoodStuffsTrait(lunchBox);
        if (traits == null) {
            return null;
        }
        MutableItemStorage mutable = traits.mutable(ComponentHolder.of(lunchBox));
        if (((MutableBundleLike)mutable).isEmpty()) {
            return null;
        }
        int selectedSlotSafe = ((MutableBundleLike)mutable).getSelectedSlot(player);
        return ((MutableBundleLike)mutable).getItemStacks().get(selectedSlotSafe);
    }

    default public boolean mouseScrolled(Player player, ComponentHolder holder, int slotIndex, int containerId, int scrolled) {
        int startSlot;
        IMutableSelectionTrait mutable = (IMutableSelectionTrait)this.mutable(holder);
        int i = mutable.stepScrollTo(startSlot = mutable.getSelectedSlot(player), scrolled);
        if (i == startSlot) {
            return false;
        }
        mutable.setSelectedSlot(player, i);
        SyncSelectedSlot.send(containerId, slotIndex, i);
        return true;
    }

    public <T extends MutableBundleLike<?>> T mutable(ComponentHolder var1);

    public boolean isFull(ComponentHolder var1);

    private SlotSelection getSlotSelection(ComponentHolder holder) {
        SlotSelection slotSelection = holder.get(ITraitData.SLOT_SELECTION);
        if (slotSelection != null) {
            return slotSelection;
        }
        SlotSelection selection = new SlotSelection();
        holder.set(ITraitData.SLOT_SELECTION, selection);
        return selection;
    }

    default public int getSelectedSlot(ComponentHolder holder, Player player) {
        return this.getSlotSelection(holder).get(player);
    }

    @Nullable
    default public ItemStack getHoverItem(ComponentHolder holder, Player player) {
        List<ItemStack> stacks = holder.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return null;
        }
        int selectedSlot = this.getSelectedSlot(holder, player);
        return stacks.get(selectedSlot);
    }
}

