/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.backpack;

import com.beansgalaxy.backpacks.access.EquipmentSlotAccess;
import com.beansgalaxy.backpacks.screen.TraitMenu;
import com.beansgalaxy.backpacks.traits.IClientTraits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.bundle.BundleMenu;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import org.apache.commons.lang3.math.Fraction;

public class BackpackClient
implements IClientTraits<BackpackTraits> {
    public static final BackpackClient INSTANCE = new BackpackClient();

    @Override
    public int getBarWidth(BackpackTraits trait, ComponentHolder holder) {
        Fraction fullness = trait.fullness(holder);
        if (trait.isFull(holder)) {
            return 14;
        }
        float value = fullness.multiplyBy(Fraction.getFraction((int)13, (int)1)).floatValue();
        return Mth.floor((float)value) + 1;
    }

    @Override
    public int getBarColor(BackpackTraits trait, ComponentHolder holder) {
        if (trait.isFull(holder)) {
            return RED_BAR;
        }
        return 0xFFAA00;
    }

    @Override
    public TraitMenu<BackpackTraits> createTooltip(Minecraft minecraft, int leftPos, int topPos, int screenHeight, int screenWidth, Slot slot, ComponentHolder holder, BackpackTraits traits) {
        if (slot instanceof EquipmentSlotAccess) {
            EquipmentSlotAccess access = (EquipmentSlotAccess)slot;
            if (traits.slots().test(access.getSlot())) {
                return new BundleMenu<BackpackTraits>(minecraft, leftPos, topPos, screenHeight, screenWidth, slot, holder, traits);
            }
        }
        return null;
    }

    @Override
    public void appendTooltipLines(BackpackTraits traits, Consumer<Component> lines) {
        int size = traits.size();
        lines.accept((Component)Component.translatable((String)("traits.beansbackpacks.tooltip." + traits.name() + (size == 1 ? ".solo" : ".size")), (Object[])new Object[]{size}).withStyle(ChatFormatting.GOLD));
    }
}

