/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.backpack;

import com.beansgalaxy.backpacks.components.equipable.EquipmentGroups;
import com.beansgalaxy.backpacks.traits.ITraitCodec;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ModSound;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class BackpackCodecs
implements ITraitCodec<BackpackTraits> {
    public static final BackpackCodecs INSTANCE = new BackpackCodecs();
    public static final Codec<BackpackTraits> CODEC = RecordCodecBuilder.create(in -> in.group((App)PrimitiveCodec.INT.fieldOf("size").validate(size -> size < 256 ? (size > 0 ? DataResult.success((Object)size) : DataResult.error(() -> "The provided field \"size\" must be greater than 0; Provided=" + size, (Object)1)) : DataResult.error(() -> "The provided field \"size\" must be smaller than 256; Provided=" + size, (Object)255)).forGetter(BundleLikeTraits::size), (App)ModSound.MAP_CODEC.forGetter(GenericTraits::sound), (App)EquipmentGroups.CODEC.optionalFieldOf("slot", (Object)EquipmentGroups.BODY).forGetter(BackpackTraits::slots), (App)ResourceLocation.CODEC.optionalFieldOf("texture", (Object)ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"null")).forGetter(BackpackTraits::getTexture)).apply((Applicative)in, (size, sound, slot, texture) -> new BackpackTraits((ModSound)((Object)((Object)sound)), (int)size, (EquipmentGroups)((Object)((Object)slot)), (ResourceLocation)texture)));
    public static final StreamCodec<RegistryFriendlyByteBuf, BackpackTraits> STREAM_CODEC = StreamCodec.of((buf, traits) -> {
        ModSound.STREAM_CODEC.encode(buf, (Object)traits.sound());
        buf.writeInt(traits.size());
        buf.writeEnum((Enum)traits.slots());
        buf.writeResourceLocation(traits.getTexture());
    }, buf -> new BackpackTraits((ModSound)((Object)((Object)ModSound.STREAM_CODEC.decode(buf))), buf.readInt(), (EquipmentGroups)buf.readEnum(EquipmentGroups.class), buf.readResourceLocation()));

    @Override
    public Codec<BackpackTraits> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, BackpackTraits> streamCodec() {
        return STREAM_CODEC;
    }
}

