/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.backpack;

import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BackpackMutable
extends MutableBundleLike<BackpackTraits> {
    public BackpackMutable(BackpackTraits traits, ComponentHolder holder) {
        super(traits, holder);
    }

    public void pickItem(int index, int amount, SlotAccess access) {
        ItemStack stack;
        List<ItemStack> stacks = this.getItemStacks();
        if (amount == -1) {
            stack = stacks.remove(index);
        } else {
            ItemStack item = stacks.get(index);
            stack = item.copyWithCount(amount);
            item.shrink(amount);
        }
        access.set(stack);
        this.push();
    }

    public void pickBlock(Player player, int index, int amount, int freeSlot) {
        ItemStack stack;
        List<ItemStack> stacks = this.getItemStacks();
        if (amount == -1) {
            stack = stacks.remove(index);
        } else {
            ItemStack item = stacks.get(index);
            stack = item.copyWithCount(amount);
            item.shrink(amount);
        }
        Inventory inventory = player.getInventory();
        int selected = inventory.selected;
        ItemStack inHand = (ItemStack)inventory.items.get(selected);
        if (!inHand.isEmpty()) {
            if (freeSlot < 9) {
                inventory.selected = freeSlot;
            } else {
                inventory.items.set(freeSlot, (Object)inHand);
            }
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, stack);
        this.push();
    }
}

