/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.backpack;

import com.beansgalaxy.backpacks.components.equipable.EquipmentGroups;
import com.beansgalaxy.backpacks.network.serverbound.PickBlock;
import com.beansgalaxy.backpacks.network.serverbound.PickItem;
import com.beansgalaxy.backpacks.traits.IEntityTraits;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackClient;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.bundle.BundleHopper;
import com.beansgalaxy.backpacks.traits.bundle.BundleScreen;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BackpackTraits
extends BundleLikeTraits
implements IEntityTraits<BackpackTraits> {
    public static final String NAME = "backpack";
    private final EquipmentGroups slot;
    private final ResourceLocation texture;

    public BackpackTraits(ModSound sound, int size, EquipmentGroups slot, ResourceLocation texture) {
        super(sound, size);
        this.slot = slot;
        this.texture = texture;
    }

    @Nullable
    public static BackpackTraits get(ItemStack stack) {
        return Traits.get(ComponentHolder.of(stack), Traits.BACKPACK);
    }

    public static void runAllEquipped(LivingEntity entity, BiConsumer<BackpackTraits, EquipmentSlot> runnable) {
        EquipmentSlot[] values = EquipmentSlot.values();
        for (int i = values.length - 1; i >= 0; --i) {
            EquipmentSlot slot = values[i];
            ItemStack backpack = entity.getItemBySlot(slot);
            BackpackTraits traits = BackpackTraits.get(backpack);
            if (traits == null) continue;
            runnable.accept(traits, slot);
        }
    }

    public static void runIfEquipped(Player player, BiPredicate<BackpackTraits, EquipmentSlot> runnable) {
        EquipmentSlot[] values = EquipmentSlot.values();
        int size = values.length;
        for (int i = size - 1; i >= 0; --i) {
            BackpackTraits traits;
            EquipmentSlot slot = values[i];
            ItemStack stack = player.getItemBySlot(slot);
            if (stack.isEmpty() || (traits = BackpackTraits.get(stack)) == null || !traits.slots().test(slot) || !runnable.test(traits, slot)) continue;
            return;
        }
    }

    @Override
    public void use(Level level, Player player, InteractionHand hand, ComponentHolder holder, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack backpack = player.getItemInHand(hand);
        EquipmentSlot slotCanidate = null;
        for (EquipmentSlot value : this.slots().getValues()) {
            boolean isEmpty;
            ItemStack equipped = player.getItemBySlot(value);
            if (equipped.isEmpty()) {
                player.setItemSlot(value, backpack);
                player.setItemInHand(hand, ItemStack.EMPTY);
                cir.setReturnValue((Object)InteractionResultHolder.success((Object)backpack));
                return;
            }
            if (slotCanidate != null) continue;
            if (player.isCreative()) {
                slotCanidate = value;
                continue;
            }
            boolean hasBinding = EnchantmentHelper.has((ItemStack)equipped, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE);
            boolean bl = isEmpty = !Traits.testIfPresent(equipped, traits -> !traits.isEmpty(equipped));
            if (hasBinding || !isEmpty) continue;
            slotCanidate = value;
        }
        if (slotCanidate != null) {
            ItemStack equipped = player.getItemBySlot(slotCanidate);
            player.setItemSlot(slotCanidate, backpack);
            player.setItemInHand(hand, equipped);
            cir.setReturnValue((Object)InteractionResultHolder.success((Object)backpack));
        }
    }

    @Override
    public void stackedOnOther(ComponentHolder backpack, ItemStack other, Slot slot, ClickAction click, Player player, CallbackInfoReturnable<Boolean> cir) {
    }

    public boolean pickupToBackpack(Player player, EquipmentSlot equipmentSlot, Inventory inventory, ItemStack backpack, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!this.isFull(backpack)) {
            inventory.items.forEach(stacks -> {
                if (ItemStack.isSameItemSameComponents((ItemStack)stacks, (ItemStack)stack)) {
                    int present = stacks.getCount();
                    int inserted = stack.getCount();
                    int count = present + inserted;
                    int remainder = Math.max(0, count - stack.getMaxStackSize());
                    stacks.setCount(count -= remainder);
                    stack.setCount(remainder);
                }
            });
            if (stack.isEmpty()) {
                cir.setReturnValue((Object)true);
                return true;
            }
            BackpackMutable mutable = this.mutable(ComponentHolder.of(backpack));
            Iterator<ItemStack> iterator = mutable.getItemStacks().iterator();
            while (iterator.hasNext() && !stack.isEmpty()) {
                ItemStack returnStack;
                ItemStack itemStack = iterator.next();
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack) || (returnStack = mutable.addItem(stack)) == null) continue;
                cir.setReturnValue((Object)true);
            }
            if (cir.isCancelled() && ((Boolean)cir.getReturnValue()).booleanValue()) {
                this.sound().toClient(player, ModSound.Type.INSERT, 1.0f, 1.0f);
                mutable.push();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    List<Pair> pSlots = List.of(Pair.of((Object)equipmentSlot, (Object)backpack));
                    ClientboundSetEquipmentPacket packet = new ClientboundSetEquipmentPacket(serverPlayer.getId(), pSlots);
                    serverPlayer.serverLevel().getChunkSource().broadcastAndSend((Entity)serverPlayer, (Packet)packet);
                }
            }
            return stack.isEmpty();
        }
        return false;
    }

    @Override
    public EquipmentGroups slots() {
        return this.slot;
    }

    @Override
    public String name() {
        return NAME;
    }

    public BackpackClient client() {
        return BackpackClient.INSTANCE;
    }

    @Override
    public TraitComponentKind<? extends GenericTraits> kind() {
        return Traits.BACKPACK;
    }

    @Override
    public BackpackMutable mutable(ComponentHolder holder) {
        return new BackpackMutable(this, holder);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public void hotkeyThrow(Slot slot, ComponentHolder backpack, int button, Player player, boolean menuKeyDown, CallbackInfo ci) {
        ItemStack itemStack;
        if (this.isEmpty(backpack)) {
            return;
        }
        BackpackMutable mutable = this.mutable(backpack);
        int selectedSlot = mutable.getSelectedSlot(player);
        ItemStack removed = menuKeyDown ? mutable.removeItem(selectedSlot) : ((itemStack = mutable.getItemStacks().get(selectedSlot)).getCount() == 1 ? mutable.removeItem(selectedSlot) : itemStack.split(1));
        player.drop(removed, true);
        this.sound().atClient(player, ModSound.Type.REMOVE);
        mutable.push();
        ci.cancel();
    }

    @Override
    public InteractionResult interact(BackpackEntity backpackEntity, Player player, InteractionHand hand) {
        if (player.level().isClientSide) {
            BundleScreen.openScreen(player, backpackEntity.viewable, this);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onBreak(BackpackEntity backpack, boolean dropItems) {
        List<ItemStack> stacks = backpack.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return;
        }
        Level level = backpack.level();
        double x = backpack.getX();
        double y = backpack.getY();
        double z = backpack.getZ();
        if (dropItems && !level.isClientSide) {
            for (ItemStack stack : stacks) {
                ItemEntity itementity = new ItemEntity(level, x, y, z, stack);
                itementity.setDefaultPickUpDelay();
                RandomSource random = backpack.getRandom();
                double a = random.nextDouble() - 0.5;
                double b = a * Math.abs(a);
                double c = random.nextDouble() - 0.5;
                double d = c * Math.abs(c);
                Vec3 vec3 = new Vec3(b, Math.abs(a * c) + 0.5, d).scale(0.35);
                itementity.setDeltaMovement(vec3);
                level.addFreshEntity((Entity)itementity);
            }
        }
        backpack.remove(ITraitData.ITEM_STACKS);
    }

    @Override
    public Container createHopperContainer(BackpackEntity backpack) {
        return new BundleHopper(backpack, this);
    }

    public boolean pickItemClient(Player player, EquipmentSlot slot, SlotAccess access, AbstractContainerMenu menu, ItemStack hoveredStack, CallbackInfoReturnable<Boolean> cir) {
        ItemStack backpack = player.getItemBySlot(slot);
        BackpackMutable mutable = this.mutable(ComponentHolder.of(backpack));
        List<ItemStack> stacks = mutable.getItemStacks();
        for (int i = 0; i < stacks.size(); ++i) {
            int maxStackSize;
            ItemStack stack = stacks.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)hoveredStack, (ItemStack)stack)) continue;
            int count = stack.getCount();
            if (count > (maxStackSize = stack.getMaxStackSize())) {
                mutable.pickItem(i, maxStackSize, access);
                PickItem.send(menu.containerId, i, maxStackSize, slot);
            } else {
                mutable.pickItem(i, -1, access);
                PickItem.send(menu.containerId, i, -1, slot);
            }
            this.sound().atClient(player, ModSound.Type.REMOVE);
            cir.setReturnValue((Object)true);
            return true;
        }
        return false;
    }

    public void pickBlockClient(Player player, EquipmentSlot slot, Inventory inventory, ItemStack matchedStack, CallbackInfo ci) {
        ItemStack backpack = player.getItemBySlot(slot);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return;
        }
        int freeSlot = inventory.getFreeSlot();
        if (freeSlot == -1) {
            this.sound().atClient(player, ModSound.Type.HIT);
            return;
        }
        ComponentHolder holder = ComponentHolder.of(backpack);
        BackpackMutable mutable = traits.mutable(holder);
        List<ItemStack> stacks = mutable.getItemStacks();
        for (int i = 0; i < stacks.size(); ++i) {
            int maxStackSize;
            ItemStack stack = stacks.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)matchedStack, (ItemStack)stack)) continue;
            int count = stack.getCount();
            int amount = count > (maxStackSize = stack.getMaxStackSize()) ? maxStackSize : -1;
            mutable.pickBlock(player, i, amount, freeSlot);
            PickBlock.send(i, amount, slot, freeSlot);
            this.sound().atClient(player, ModSound.Type.REMOVE);
            mutable.push();
            ci.cancel();
            return;
        }
    }
}

