/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.bundle;

import com.beansgalaxy.backpacks.data.HopperTraitContainer;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BundleHopper
extends HopperTraitContainer<MutableBundleLike<? extends BundleLikeTraits>> {
    public BundleHopper(BackpackEntity backpack, BundleLikeTraits traits) {
        super(backpack, traits.mutable(backpack));
    }

    public int getContainerSize() {
        return ((MutableBundleLike)this.mutable).getItemStacks().size();
    }

    public ItemStack getItem(int i) {
        if (i >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        List<ItemStack> stacks = ((MutableBundleLike)this.mutable).getItemStacks();
        return stacks.get(i);
    }

    public ItemStack removeItem(int i, int amount) {
        if (i >= this.getContainerSize() || amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.getItem(i);
        ItemStack itemStack = stack.copyWithCount(amount);
        stack.shrink(amount);
        if (stack.isEmpty()) {
            ((MutableBundleLike)this.mutable).getItemStacks().remove(i);
        }
        this.setChanged();
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int i) {
        if (i >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        ItemStack removed = ((MutableBundleLike)this.mutable).getItemStacks().remove(i);
        this.setChanged();
        return removed;
    }

    public void setItem(int i, @NotNull ItemStack itemStack) {
        ItemStack stack = ((MutableBundleLike)this.mutable).addItem(itemStack, i);
        if (stack != null) {
            this.setChanged();
        }
    }

    public void clearContent() {
    }
}

