/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.bundle;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.network.serverbound.TraitMenuClick;
import com.beansgalaxy.backpacks.screen.TraitMenu;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BundleMenu<T extends BundleLikeTraits>
extends TraitMenu<T> {
    int rows;
    int columns;
    int size;
    @Nullable
    private DragInstance dragInstance = null;
    @Nullable
    private tSlot hoveredSlot = null;

    public BundleMenu(Minecraft minecraft, int screenLeft, int screenTop, int screenHeight, int screenWidth, Slot slot, ComponentHolder holder, T traits) {
        super(minecraft, screenLeft, screenTop, screenHeight, screenWidth, slot, holder, traits);
        this.updateSize();
        double offset = (double)slot.y * 0.1 - 2.0;
        int drift = (int)((double)(this.rows - 1) * offset);
        this.topPos -= (double)(drift + 2);
    }

    protected boolean hasSpace() {
        return ((BundleLikeTraits)this.traits).fullness(this.holder).compareTo(Fraction.ONE) != 0;
    }

    private void updateSize() {
        List<ItemStack> stacks = this.holder.get(ITraitData.ITEM_STACKS);
        this.size = stacks == null ? 0 : stacks.size();
        int sudoSize = this.size + (this.hasSpace() ? 1 : 0);
        int forRow = 1;
        int columns = Math.min(sudoSize, 4);
        int rows = 1;
        for (int i = columns; i <= sudoSize; ++i) {
            if (i <= columns * rows) continue;
            if (forRow == 2) {
                ++columns;
                forRow = 0;
                continue;
            }
            ++rows;
            ++forRow;
        }
        this.columns = columns;
        this.rows = rows;
    }

    @Override
    protected int getWidth() {
        return this.columns * 16 + 16;
    }

    @Override
    protected int getHeight() {
        return this.rows * 16 + 8;
    }

    @Override
    public void mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, CallbackInfoReturnable<Boolean> cir) {
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY, cir);
        if (this.dragInstance != null) {
            if (!this.dragInstance.hasMoved) {
                this.dragInstance.hasMoved = true;
            } else {
                this.dragInstance.move(mouseX, mouseY);
            }
        } else if (this.hoveredSlot == null || this.hoveredSlot.isEmpty) {
            LocalPlayer player = this.minecraft.player;
            AbstractContainerMenu containerMenu = player.containerMenu;
            if (containerMenu.getCarried().isEmpty()) {
                this.dragInstance = new DragInstance(mouseX, mouseY, button);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Override
    public void menuClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        this.dragInstance = null;
        if (this.hoveredSlot != null) {
            LocalPlayer player = this.minecraft.player;
            AbstractContainerMenu containerMenu = player.containerMenu;
            TraitMenuClick.Kind clickType = this.getClickType(button);
            TraitMenuClick.send(containerMenu.containerId, this.slot, this.hoveredSlot.index, clickType);
            SlotAccess access = SlotAccess.of(() -> ((AbstractContainerMenu)containerMenu).getCarried(), arg_0 -> ((AbstractContainerMenu)containerMenu).setCarried(arg_0));
            ((BundleLikeTraits)this.traits).menuClick(this.holder, this.hoveredSlot.index, clickType, access, (Player)player);
            cir.setReturnValue((Object)true);
        }
        this.updateSize();
    }

    private TraitMenuClick.Kind getClickType(int button) {
        boolean eitherShiftDown;
        boolean bl = eitherShiftDown = InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)344);
        if (eitherShiftDown) {
            return TraitMenuClick.Kind.SHIFT;
        }
        if (button == 1) {
            return TraitMenuClick.Kind.RIGHT;
        }
        return TraitMenuClick.Kind.LEFT;
    }

    @Override
    public void dropHoveredItem(CallbackInfoReturnable<Boolean> cir) {
        if (this.hoveredSlot == null) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        AbstractContainerMenu containerMenu = player.containerMenu;
        TraitMenuClick.Kind clickType = TraitMenuClick.Kind.DROP;
        TraitMenuClick.send(containerMenu.containerId, this.slot, this.hoveredSlot.index, clickType);
        SlotAccess access = SlotAccess.of(() -> ((AbstractContainerMenu)containerMenu).getCarried(), arg_0 -> ((AbstractContainerMenu)containerMenu).setCarried(arg_0));
        ((BundleLikeTraits)this.traits).menuClick(this.holder, this.hoveredSlot.index, clickType, access, (Player)player);
        this.updateSize();
    }

    @Override
    protected void menuRender(AbstractContainerScreen<?> screen, GuiGraphics gui, int mouseX, int mouseY) {
        if (this.isFocused()) {
            BundleMenu.renderTooltipBackground(gui, 8, 4, this.getWidth() - 16, this.getHeight() - 8, 0);
        } else {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gui, (int)8, (int)4, (int)(this.getWidth() - 16), (int)(this.getHeight() - 8), (int)0);
        }
        this.renderItems(gui, mouseX, mouseY);
    }

    public static void renderTooltipBackground(GuiGraphics pGuiGraphics, int pX, int pY, int pWidth, int pHeight, int pZ) {
        int i = pX - 3;
        int j = pY - 3;
        int k = pWidth + 3 + 3;
        int l = pHeight + 3 + 3;
        BundleMenu.renderHorizontalLine(pGuiGraphics, i, j - 1, k, pZ, -267386864);
        BundleMenu.renderHorizontalLine(pGuiGraphics, i, j + l, k, pZ, -267386864);
        BundleMenu.renderRectangle(pGuiGraphics, i, j, k, l, pZ, -267386864);
        BundleMenu.renderVerticalLine(pGuiGraphics, i - 1, j, l, pZ, -267386864);
        BundleMenu.renderVerticalLine(pGuiGraphics, i + k, j, l, pZ, -267386864);
        BundleMenu.renderFrameGradient(pGuiGraphics, i, j + 1, k, l, pZ, -1593857536, 1357607188);
    }

    private static void renderFrameGradient(GuiGraphics pGuiGraphics, int pX, int pY, int pWidth, int pHeight, int pZ, int pTopColor, int pBottomColor) {
        BundleMenu.renderVerticalLineGradient(pGuiGraphics, pX, pY, pHeight - 2, pZ, pTopColor, pBottomColor);
        BundleMenu.renderVerticalLineGradient(pGuiGraphics, pX + pWidth - 1, pY, pHeight - 2, pZ, pTopColor, pBottomColor);
        BundleMenu.renderHorizontalLine(pGuiGraphics, pX, pY - 1, pWidth, pZ, pTopColor);
        BundleMenu.renderHorizontalLine(pGuiGraphics, pX, pY - 1 + pHeight - 1, pWidth, pZ, pBottomColor);
    }

    private static void renderVerticalLine(GuiGraphics pGuiGraphics, int pX, int pY, int pLength, int pZ, int pColor) {
        pGuiGraphics.fill(pX, pY, pX + 1, pY + pLength, pZ, pColor);
    }

    private static void renderVerticalLineGradient(GuiGraphics pGuiGraphics, int pX, int pY, int pLength, int pZ, int pTopColor, int pBottomColor) {
        pGuiGraphics.fillGradient(pX, pY, pX + 1, pY + pLength, pZ, pTopColor, pBottomColor);
    }

    private static void renderHorizontalLine(GuiGraphics pGuiGraphics, int pX, int pY, int pLength, int pZ, int pColor) {
        pGuiGraphics.fill(pX, pY, pX + pLength, pY + 1, pZ, pColor);
    }

    private static void renderRectangle(GuiGraphics pGuiGraphics, int pX, int pY, int pWidth, int pHeight, int pZ, int pColor) {
        pGuiGraphics.fill(pX, pY, pX + pWidth, pY + pHeight, pZ, pColor);
    }

    private void renderItems(GuiGraphics gui, int mouseX, int mouseY) {
        this.updateSize();
        List<ItemStack> stacks = this.holder.get(ITraitData.ITEM_STACKS);
        this.hoveredSlot = null;
        tSlot lastSlot = null;
        block0: for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.columns; ++x) {
                boolean isHovered;
                int i = y * this.columns + x;
                int x1 = x * 16 + 8;
                int y1 = y * 16 + 4;
                int x2 = x1 + 16;
                int y2 = y1 + 16;
                boolean bl = isHovered = this.isFocused && mouseX >= x1 && mouseY >= y1 && mouseX < x2 && mouseY < y2;
                if (i == this.size) {
                    lastSlot = new tSlot(i, x1, x2, y1, y2, true);
                }
                if (i >= this.size) {
                    if (!isHovered) continue;
                    this.hoveredSlot = lastSlot;
                    continue;
                }
                if (isHovered) {
                    this.hoveredSlot = new tSlot(i, x1, x2, y1, y2, false);
                }
                if (stacks == null) continue block0;
                Font font = this.minecraft.font;
                ItemStack stack = stacks.get(i);
                PoseStack pose = gui.pose();
                pose.pushPose();
                CommonClient.renderItem(this.minecraft, gui, stack, x1 + 8, y1 + 8, 50, false);
                CommonClient.renderItemDecorations(gui, font, stack, x1 + 8, y1 + 8, 50);
                pose.popPose();
                if (!isHovered) continue;
                List lines = Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)stack);
                Optional image = stack.getTooltipImage();
                Integer imageHeight = image.map(ClientTooltipComponent::create).map(ClientTooltipComponent::getHeight).orElse(0);
                int linesSize = lines.size();
                int linesHeight = linesSize < 2 ? 12 : 14 + (linesSize - 1) * 10;
                int height = imageHeight + linesHeight;
                gui.renderTooltip(font, lines, image, -4, -height + 10);
            }
        }
        if (this.hoveredSlot != null) {
            gui.fill(this.hoveredSlot.x1, this.hoveredSlot.y1, this.hoveredSlot.x2, this.hoveredSlot.y2, 100, 0x60FFFFFF);
        }
    }

    private final class DragInstance {
        final double startX;
        final double startY;
        final int button;
        boolean hasMoved = false;
        double currentX;
        double currentY;

        private DragInstance(double startX, double startY, int button) {
            this.startX = startX;
            this.startY = startY;
            this.button = button;
            this.currentX = startX;
            this.currentY = startY;
        }

        void move(double mouseX, double mouseY) {
            double oX = mouseX - this.currentX;
            double oY = mouseY - this.currentY;
            this.currentX += oX;
            this.currentY += oY;
            BundleMenu.this.leftPos += oX;
            BundleMenu.this.topPos += oY;
        }
    }

    record tSlot(int index, int x1, int x2, int y1, int y2, boolean isEmpty) {
    }
}

