/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.bundle;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.network.serverbound.TinyHotbarClick;
import com.beansgalaxy.backpacks.network.serverbound.TinyMenuClick;
import com.beansgalaxy.backpacks.network.serverbound.TinyMenuInteract;
import com.beansgalaxy.backpacks.screen.BackpackScreen;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.util.SplitText;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class BundleScreen
extends BackpackScreen {
    protected final BundleLikeTraits traits;
    protected BundleTraitSlot lastSlot = null;

    public static void openScreen(Player player, ViewableBackpack backpack, BundleLikeTraits traits) {
        Minecraft minecraft = Minecraft.getInstance();
        BundleScreen screen = new BundleScreen(player, backpack, traits);
        minecraft.setScreen((Screen)screen);
        backpack.onOpen(player);
        TinyMenuInteract.send(backpack.getId(), true);
    }

    protected BundleScreen(Player player, ViewableBackpack backpack, BundleLikeTraits traits) {
        super(player.inventoryMenu, player.getInventory(), backpack);
        this.traits = traits;
    }

    public int traitTop() {
        return this.topPos + 84;
    }

    @Override
    protected void repopulateSlots(@NotNull GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        int size;
        boolean hasSpace;
        ItemStack carried = this.getCarried();
        List<ItemStack> stacks = this.backpack.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            hasSpace = true;
            size = 1;
        } else {
            hasSpace = this.traits.fullness(stacks).compareTo(Fraction.ONE) != 0;
            size = stacks.size() + (hasSpace ? 1 : 0) + (carried.isEmpty() ? 0 : 1);
        }
        int guiScaledWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int maxWidth = guiScaledWidth / 2 - 126;
        boolean forCol = false;
        int columns = Math.min(size, 4);
        int rows = 1;
        for (int i = columns; i <= size; ++i) {
            if (i <= columns * rows) continue;
            if (forCol && maxWidth > 0) {
                ++columns;
                maxWidth -= 18;
            } else {
                ++rows;
            }
            forCol = !forCol;
        }
        this.clearSlots();
        int width = columns * 18;
        int right = this.leftPos - 18;
        int left = right - width;
        int top = this.traitTop() - 11 - (rows - 1) / 2 * 10;
        int i = hasSpace ? -1 : 0;
        MutableComponent title = Component.empty();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                ItemStack stack;
                BundleTraitSlot slot = new BundleTraitSlot(left + x * 18, top + y * 18, i);
                if (slot.isMouseOver(pMouseX, pMouseY) && !(stack = slot.getItem()).isEmpty()) {
                    List tooltipFromItem = Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)stack);
                    title = (Component)tooltipFromItem.getFirst();
                }
                this.addSlot(slot);
                if (++i != size - (carried.isEmpty() ? 0 : 1)) continue;
                this.lastSlot = slot;
            }
        }
        int fontWidth = this.font.width((FormattedText)title);
        int fontHeight = 10;
        PoseStack pose = gui.pose();
        pose.translate(0.0f, 0.0f, 100.0f);
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 1.0f);
        if (fontWidth > width) {
            int height;
            FormattedCharSequence text = title.getVisualOrderText();
            SplitText splitText = new SplitText(text);
            splitText.split();
            ArrayList<FormattedCharSequence> split = new ArrayList<FormattedCharSequence>();
            int newWidth = splitText.noCropWidth(this.font, width, split);
            left = left + width - newWidth;
            width = newWidth;
            int splitRow = height = split.size() * 10;
            for (FormattedCharSequence sequence : split) {
                int seqWidth = this.font.width(sequence);
                gui.drawString(this.minecraft.font, sequence, right - seqWidth, top - splitRow, -1);
                splitRow -= 10;
            }
            fontHeight = height;
        } else {
            gui.drawString(this.minecraft.font, (Component)title, right - fontWidth, top - 10, -1);
        }
        this.traitX = left + width;
        this.traitY = top - fontHeight;
        this.traitW = width;
        this.traitH = rows * 18 + fontHeight;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gui, (int)(left - 1), (int)(top - 1 - fontHeight), (int)(width + 2), (int)(rows * 18 + 3 + fontHeight), (int)0);
        for (BackpackScreen.TraitSlot slot : this.slots) {
            slot.render(gui, pMouseX, pMouseY, pPartialTick);
        }
        pose.popPose();
    }

    @Override
    protected final void tinyMenuClick(int index, TinyClickType clickType, SlotAccess carriedAccess, LocalPlayer player) {
        this.traits.tinyMenuClick(this.backpack, index, clickType, carriedAccess, (Player)player);
        TinyMenuClick.send(this.backpack, index, clickType);
    }

    @Override
    protected final void tinyHotbarClick(TinyClickType clickType, InventoryMenu menu, LocalPlayer player, int index) {
        this.traits.tinyHotbarClick(this.backpack, index, clickType, menu, (Player)player);
        TinyHotbarClick.send(this.backpack, index, clickType);
    }

    private int lastSlotIndex() {
        List<ItemStack> stacks = this.backpack.get(ITraitData.ITEM_STACKS);
        return stacks == null ? 0 : stacks.size();
    }

    public class BundleTraitSlot
    extends BackpackScreen.TraitSlot {
        public BundleTraitSlot(int pX, int pY, int index) {
            super(pX, pY, index);
        }

        @Override
        public ItemStack getItem() {
            List<ItemStack> stacks = BundleScreen.this.backpack.get(ITraitData.ITEM_STACKS);
            if (stacks == null || this.index == -1) {
                return ItemStack.EMPTY;
            }
            return this.index < stacks.size() ? stacks.get(this.index) : ItemStack.EMPTY;
        }

        protected void renderWidget(GuiGraphics gui, int i, int i1, float v) {
            ItemStack stack = this.getItem();
            boolean hovered = this.isHovered();
            int x = this.getX() + 9;
            int y = this.getY() + 9;
            if (!stack.isEmpty()) {
                Minecraft minecraft = Minecraft.getInstance();
                CommonClient.renderItem(minecraft, gui, stack, x, y, 50, false);
                CommonClient.renderItemDecorations(gui, BundleScreen.this.font, stack, x, y, 50);
                if (hovered) {
                    gui.fill(x - 8, y - 8, x + 8, y + 8, 100, -2130706433);
                }
            } else if (hovered) {
                if (this == BundleScreen.this.slots.getFirst()) {
                    gui.fill(x - 8, y - 8, x + 8, y + 8, 100, -2130706433);
                } else if (BundleScreen.this.lastSlot != null) {
                    int x1 = BundleScreen.this.lastSlot.getX() + 9;
                    int y1 = BundleScreen.this.lastSlot.getY() + 9;
                    gui.fill(x1 - 8, y1 - 8, x1 + 8, y1 + 8, 100, -2130706433);
                }
            }
        }

        @Override
        public void hotbarClick(int hotbarSlot) {
            LocalPlayer player = ((BundleScreen)BundleScreen.this).minecraft.player;
            final AbstractContainerMenu menu = player.containerMenu;
            SlotAccess carriedAccess = new SlotAccess(){

                public ItemStack get() {
                    return menu.getCarried();
                }

                public boolean set(ItemStack p_150452_) {
                    menu.setCarried(p_150452_);
                    return true;
                }
            };
            if (this.index == -1) {
                BundleScreen.this.tinyHotbarClick(TinyClickType.SHIFT, player.inventoryMenu, player, hotbarSlot);
                return;
            }
            int lastSlot = BundleScreen.this.lastSlotIndex();
            if (this.index >= lastSlot) {
                BundleScreen.this.tinyHotbarClick(TinyClickType.I_SHIFT, player.inventoryMenu, player, hotbarSlot);
            } else {
                TinyClickType clickType = TinyClickType.getHotbar(hotbarSlot);
                BundleScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
            }
        }
    }
}

