/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.reference.NonTrait;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.traits.IEntityTraits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.util.CollidingVertexMap;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.beansgalaxy.backpacks.util.data_fixers.RecoverLocalData;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BackpackEntity
extends Entity
implements ComponentHolder {
    public static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.defineId(BackpackEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.defineId(BackpackEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.defineId(BackpackEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public final ViewableBackpack viewable = new ViewableBackpack(){

        @Override
        public void setOpen(boolean isOpen) {
            BackpackEntity.this.entityData.set(IS_OPEN, (Object)isOpen);
        }

        @Override
        public boolean isOpen() {
            return (Boolean)BackpackEntity.this.entityData.get(IS_OPEN);
        }

        @Override
        public void playSound(ModSound.Type type) {
            BackpackEntity.this.getTraits().sound().at(BackpackEntity.this, type);
        }

        @Override
        @NotNull
        public Entity entity() {
            return BackpackEntity.this;
        }

        @Override
        protected ComponentHolder holder() {
            return BackpackEntity.this;
        }

        @Override
        public ItemStack toStack() {
            ItemStack stack = BackpackEntity.this.toStack();
            stack.setEntityRepresentation((Entity)BackpackEntity.this);
            return stack;
        }

        @Override
        public boolean shouldClose() {
            return false;
        }

        @Override
        public float fallDistance() {
            return BackpackEntity.this.fallDistance;
        }
    };
    public int breakAmount = 0;
    public static final int BACKPACK_HEALTH = 24;

    public InteractionResult useTraitInteraction(Player player, InteractionHand hand) {
        IEntityTraits<?> traits = this.getTraits();
        return traits.interact(this, player, hand);
    }

    public BackpackEntity(EntityType<?> $$0, Level $$1) {
        super($$0, $$1);
        this.blocksBuilding = true;
    }

    public IEntityTraits<?> getTraits() {
        ItemStack stack = (ItemStack)this.entityData.get(ITEM_STACK);
        BackpackTraits traits = BackpackTraits.get(stack);
        return Objects.requireNonNullElse(traits, NonTrait.INSTANCE);
    }

    @Nullable
    public static BackpackEntity create(UseOnContext ctx, ItemStack backpackStack, BackpackTraits traits) {
        Vec3 pos;
        Vec3 cursor;
        Direction direction;
        Level level = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        if (level.getBlockState(blockPos).getCollisionShape((BlockGetter)level, blockPos).isEmpty()) {
            BlockHitResult hitResult = Constants.getPlayerPOVHitResult(level, player, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE);
            direction = HitResult.Type.MISS.equals((Object)hitResult.getType()) ? Direction.UP : hitResult.getDirection();
            cursor = hitResult.getLocation();
        } else {
            direction = ctx.getClickedFace();
            cursor = ctx.getClickLocation();
        }
        float yRot = switch (direction) {
            case Direction.NORTH, Direction.SOUTH -> {
                double y = BackpackEntity.snapY(player.getEyeY(), cursor);
                double z = BackpackEntity.snapXZ(cursor.x);
                pos = new Vec3(z, y - 0.3125, cursor.z);
                yield direction.toYRot();
            }
            case Direction.EAST, Direction.WEST -> {
                double y = BackpackEntity.snapY(player.getEyeY(), cursor);
                double z = BackpackEntity.snapXZ(cursor.z);
                pos = new Vec3(cursor.x, y - 0.3125, z);
                yield direction.toYRot();
            }
            default -> {
                if (direction == Direction.DOWN) {
                    cursor = cursor.add(0.0, -0.5625, 0.0);
                    direction = Direction.UP;
                }
                pos = new Vec3(Mth.lerp((double)0.85, (double)player.getX(), (double)cursor.x), cursor.y, Mth.lerp((double)0.85, (double)player.getZ(), (double)cursor.z));
                yield player.getYHeadRot() + 180.0f;
            }
        };
        Vector3f step = direction.step().mul(0.125f, 0.0f, 0.125f);
        Vec3 stepped_pos = pos.add((double)step.x, (double)step.y, (double)step.z);
        AABB aabb = BackpackEntity.newBoundingBox(direction, stepped_pos);
        Vector3f inset = direction.step().mul(-0.0625f, -0.0625f, -0.0625f);
        AABB inset_aabb = aabb.move(inset);
        CollidingVertexMap map = new CollidingVertexMap(inset_aabb, direction, level, cursor);
        map.pushClippedPoints();
        map.pushHangingPoints();
        Vector3f offset = inset.mul(-1.0f);
        AABB box = map.box.move(offset);
        if (!map.areClippedPointsStable() || !level.noBlockCollision(null, box)) {
            map.box = box;
            map.stabilizeHangingPoints();
            box = map.box;
            if (!level.noBlockCollision((Entity)player, box)) {
                return null;
            }
        }
        return BackpackEntity.create(backpackStack, traits, level, box.getBottomCenter(), yRot, direction, player);
    }

    private static double snapXZ(double clickLocation) {
        int iX = clickLocation < 0.0 ? -1 : 1;
        int block = (int)clickLocation;
        double vX = Math.abs(clickLocation - (double)block);
        double z = vX < 0.09 ? (double)block : (vX > 0.91 ? (double)(block + iX) : (vX < 0.35 ? (double)block + (double)iX * 0.25 : (vX > 0.65 ? (double)block + (double)iX * 0.75 : (double)block + (double)iX * 0.5)));
        return z;
    }

    private static double snapY(double targetY, Vec3 clickLocation) {
        double i = clickLocation.y;
        double scale = 8.0;
        double scaled = (i -= 0.0625) * scale;
        double v = i - targetY;
        double y = v > 0.0 ? (double)((int)scaled) / scale : (double)Mth.ceil((double)scaled) / scale;
        return y;
    }

    public static void drop(Player player) {
        ItemStack backpack = player.getItemBySlot(EquipmentSlot.BODY);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return;
        }
        float angle = player.yBodyRot + 180.0f;
        double radians = Math.toRadians(angle);
        double x = Math.sin(radians) * 0.25;
        double z = Math.cos(radians) * 0.25;
        BackpackEntity.create(backpack, traits, player.level(), player.position().add(x, 0.6, z), angle, Direction.UP, player);
    }

    @NotNull
    public static BackpackEntity create(ItemStack backpackStack, BackpackTraits traits, Level level, Vec3 pos, float yRot, Direction direction, Player player) {
        BackpackEntity backpackEntity = new BackpackEntity(CommonClass.BACKPACK_ENTITY.get(), level);
        backpackEntity.setPos(pos);
        backpackEntity.setYRot(yRot);
        backpackEntity.setDirection(direction);
        traits.onPlace(backpackEntity, player, backpackStack);
        backpackEntity.entityData.set(ITEM_STACK, (Object)backpackStack.copyWithCount(1));
        if (level instanceof ServerLevel) {
            level.addFreshEntity((Entity)backpackEntity);
        }
        if (direction.getAxis().isHorizontal()) {
            level.updateNeighbourForOutputSignal(backpackEntity.blockPosition(), Blocks.AIR);
        }
        backpackStack.shrink(1);
        return backpackEntity;
    }

    @NotNull
    protected AABB makeBoundingBox() {
        return BackpackEntity.newBoundingBox(this.getDirection(), this.position());
    }

    private static AABB newBoundingBox(Direction direction, Vec3 pos) {
        double d = 0.125;
        double w = 0.25;
        double h = 0.5625;
        return switch (direction) {
            case Direction.NORTH, Direction.SOUTH -> new AABB(pos.x - w, pos.y, pos.z + d, pos.x + w, pos.y + h, pos.z - d);
            case Direction.EAST, Direction.WEST -> new AABB(pos.x - d, pos.y, pos.z - w, pos.x + d, pos.y + h, pos.z + w);
            default -> {
                double width = 0.21875;
                yield new AABB(pos.add(width, h, width), pos.add(-width, 0.0, -width));
            }
        };
    }

    private static double roundForY(double i, double playerEye) {
        double scale = 8.0;
        double scaled = (i -= 0.0625) * scale;
        double v = i - playerEye;
        if (v > 0.0) {
            return 0.125 + (double)((int)scaled) / scale;
        }
        return 0.125 + (double)Mth.ceil((double)scaled) / scale;
    }

    private static double roundToScale(double position, double scale) {
        int i = position < 0.0 ? -1 : 1;
        int block = (int)position;
        double v = Math.abs(position - (double)block);
        if (v < 0.12) {
            return block;
        }
        if (v > 0.89) {
            return block + i;
        }
        if (v < 0.38) {
            return (double)block + (double)i * 0.25;
        }
        if (v > 0.63) {
            return (double)block + (double)i * 0.75;
        }
        return (double)block + (double)i * 0.5;
    }

    public ItemStack toStack() {
        return (ItemStack)this.entityData.get(ITEM_STACK);
    }

    public void tick() {
        super.tick();
        this.updateGravity();
        this.wobble();
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private void wobble() {
        if (this.viewable.wobble > 0) {
            --this.viewable.wobble;
        } else {
            this.breakAmount = 0;
        }
    }

    private void updateGravity() {
        boolean collides = !this.level().noCollision((Entity)this, this.getBoundingBox().inflate(0.1, -0.1, 0.1));
        this.setNoGravity(this.isNoGravity() && collides);
        if (!this.isNoGravity()) {
            if (this.isInWater()) {
                this.inWaterGravity();
            } else if (this.isInLava()) {
                if (this.isEyeInFluid(FluidTags.LAVA) && this.getDeltaMovement().y < 0.1) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.02, 0.0));
                }
                this.setDeltaMovement(this.getDeltaMovement().scale(0.6));
            } else if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
                this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
            }
        }
    }

    private void inWaterGravity() {
        AABB thisBox = this.getBoundingBox();
        AABB box = new AABB(thisBox.maxX, thisBox.maxY + 0.375, thisBox.maxZ, thisBox.minX, thisBox.maxY, thisBox.minZ);
        List entityList = this.getCommandSenderWorld().getEntities((Entity)this, box);
        if (!entityList.isEmpty()) {
            Entity entity = (Entity)entityList.get(0);
            double velocity = this.getY() - entity.getY();
            Object e = entityList.get(0);
            if (e instanceof Player) {
                Player player = (Player)e;
                this.setDeltaMovement(0.0, velocity / 10.0, 0.0);
            } else if (velocity < -0.6) {
                this.inWaterBob();
            } else {
                this.setDeltaMovement(0.0, velocity / 20.0, 0.0);
            }
        } else {
            this.inWaterBob();
        }
    }

    private void inWaterBob() {
        if (this.isUnderWater()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.003, 0.0));
        } else if (this.isInWater() && this.getDeltaMovement().y < 0.01) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.01, 0.0));
        }
    }

    public boolean fireImmune() {
        return ((ItemStack)this.entityData.get(ITEM_STACK)).has(DataComponents.FIRE_RESISTANT);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM_STACK, (Object)ModItems.IRON_BACKPACK.get().getDefaultInstance());
        builder.define(DIRECTION, (Object)Direction.UP);
        builder.define(IS_OPEN, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("local_data")) {
            RecoverLocalData.readEntity(this, tag);
            return;
        }
        RegistryOps serializationContext = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ItemStack stack = (ItemStack)ItemStack.OPTIONAL_CODEC.parse((DynamicOps)serializationContext, (Object)tag.get("as_stack")).getOrThrow();
        this.entityData.set(ITEM_STACK, (Object)stack);
        Direction direction = (Direction)Direction.CODEC.parse((DynamicOps)serializationContext, (Object)tag.get("direction")).getOrThrow();
        this.setDirection(direction);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        ItemStack stack = this.toStack();
        RegistryOps serializationContext = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        tag.put("as_stack", (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)serializationContext, (Object)stack).getOrThrow());
        Direction direction = this.getDirection();
        tag.put("direction", (Tag)Direction.CODEC.encodeStart((DynamicOps)serializationContext, (Object)direction).getOrThrow());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, this.getDirection().get3DDataValue());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        int data = packet.getData();
        Direction direction = Direction.from3DDataValue((int)data);
        this.setDirection(direction);
    }

    public void setDirection(Direction direction) {
        if (direction != null) {
            if (direction == Direction.DOWN) {
                direction = Direction.UP;
            }
            this.entityData.set(DIRECTION, (Object)direction);
            if (direction != Direction.UP) {
                this.setNoGravity(true);
                this.setYRot((float)direction.get2DDataValue() * 90.0f);
            }
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.setBoundingBox(this.makeBoundingBox());
        }
    }

    public Direction getDirection() {
        return (Direction)this.entityData.get(DIRECTION);
    }

    public Component getName() {
        return Constants.getName(this.toStack());
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public boolean canCollideWith(@NotNull Entity that) {
        LivingEntity livingEntity;
        if (that instanceof LivingEntity && !(livingEntity = (LivingEntity)that).isAlive()) {
            return false;
        }
        if (this.isPassengerOfSameVehicle(that)) {
            return false;
        }
        if (that instanceof BackpackEntity) {
            return true;
        }
        if (that.position().y < this.position().y) {
            return false;
        }
        return that.canBeCollidedWith() || that.isPushable();
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.toStack();
    }

    public boolean isPickable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            return this.hurt(this.damageSources().playerAttack(player), 0.0f);
        }
        return false;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity entity;
        double height = 0.1;
        if (damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.LAVA)) {
            if (this.fireImmune()) {
                return false;
            }
            this.wobble(5);
            ++this.breakAmount;
            if (this.breakAmount >= 24) {
                this.breakAndDropContents();
            }
            if ((this.breakAmount + 10) % 11 == 0) {
                this.playSound(SoundEvents.GENERIC_BURN, 0.8f, 1.0f);
            }
            return true;
        }
        if (damageSource.is(DamageTypes.PLAYER_ATTACK) && (entity = damageSource.getDirectEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (player.isCreative()) {
                IEntityTraits<?> traits = this.getTraits();
                if (!traits.isEmpty(this)) {
                    this.spawnAtLocation(this.toStack());
                }
                this.killAndUpdate(false);
            } else if (this.breakAmount + 10 >= 24) {
                this.breakAndDropContents();
            } else {
                boolean silent = this.isSilent();
                IEntityTraits<?> traits = this.getTraits();
                traits.onDamage(this, silent, traits.sound());
            }
            return true;
        }
        if (damageSource.is(DamageTypes.ON_FIRE)) {
            return false;
        }
        if (damageSource.is(DamageTypes.CACTUS)) {
            this.breakAndDropContents();
            return true;
        }
        if (damageSource.is(DamageTypes.EXPLOSION) || damageSource.is(DamageTypes.PLAYER_EXPLOSION)) {
            this.hop(height += Math.sqrt(amount) / 20.0);
            return true;
        }
        if (damageSource.is(DamageTypes.ARROW) || damageSource.is(DamageTypes.THROWN) || damageSource.is(DamageTypes.TRIDENT) || damageSource.is(DamageTypes.MOB_PROJECTILE)) {
            this.hop(height);
            return false;
        }
        this.hop(height);
        return true;
    }

    public void wobble(int amount) {
        this.viewable.wobble = Math.min(this.viewable.wobble + amount, 24);
        this.level().updateNeighbourForOutputSignal(this.blockPosition(), Blocks.AIR);
    }

    public void hop(double height) {
        if (this.isNoGravity()) {
            this.setNoGravity(false);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, height, 0.0));
        }
    }

    protected void breakAndDropContents() {
        boolean dropItems = this.level().getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS);
        IEntityTraits<?> traits = this.getTraits();
        traits.onBreak(this, dropItems);
        if (!this.isSilent()) {
            traits.sound().at(this, ModSound.Type.BREAK);
        }
        this.killAndUpdate(dropItems);
    }

    private void killAndUpdate(boolean dropItems) {
        BlockPos pPos = this.blockPosition();
        this.level().updateNeighbourForOutputSignal(pPos, Blocks.AIR);
        if (!this.isRemoved() && !this.level().isClientSide()) {
            this.kill();
            this.markHurt();
            if (dropItems) {
                ItemStack backpack = this.toStack();
                this.spawnAtLocation(backpack);
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult tryEquip;
        BackData backData = BackData.get(player);
        if (backData.isActionKeyDown() && !(tryEquip = this.tryEquip(player)).equals((Object)InteractionResult.PASS)) {
            return tryEquip;
        }
        return this.useTraitInteraction(player, hand);
    }

    public InteractionResult tryEquip(Player player) {
        if (!this.getTraits().slots().test(EquipmentSlot.BODY)) {
            return InteractionResult.PASS;
        }
        ItemStack backSlot = player.getItemBySlot(EquipmentSlot.BODY);
        if (!backSlot.isEmpty()) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = this.toStack();
        player.setItemSlot(EquipmentSlot.BODY, stack);
        this.getTraits().sound().at(this, ModSound.Type.EQUIP);
        this.killAndUpdate(false);
        return InteractionResult.SUCCESS;
    }

    private void tryInsertInventory(Player player) {
        ItemStack stack = this.toStack();
        ItemStack handStack = player.getItemBySlot(EquipmentSlot.MAINHAND);
        if (handStack.isEmpty()) {
            player.setItemSlot(EquipmentSlot.MAINHAND, stack);
            return;
        }
        Inventory inventory = player.getInventory();
        NonNullList items = inventory.items;
        for (int i = 0; i < 9; ++i) {
            ItemStack hotbarStack = (ItemStack)items.get(0);
            if (!hotbarStack.isEmpty()) continue;
            inventory.setItem(i, stack);
            inventory.selected = i;
            return;
        }
        if (!inventory.add(-1, stack)) {
            this.spawnAtLocation(stack);
        }
    }

    @Override
    @Nullable
    public <T> T remove(DataComponentType<? extends T> type) {
        ItemStack stack = (ItemStack)this.entityData.get(ITEM_STACK);
        Object removed = stack.remove(type);
        this.entityData.set(ITEM_STACK, (Object)stack);
        return (T)removed;
    }

    @Override
    public <T> void set(DataComponentType<? super T> type, T data) {
        ItemStack stack = (ItemStack)this.entityData.get(ITEM_STACK);
        stack.set(type, data);
        this.entityData.set(ITEM_STACK, (Object)stack);
    }

    @Override
    public <T> T get(DataComponentType<? extends T> type) {
        return (T)((ItemStack)this.entityData.get(ITEM_STACK)).get(type);
    }

    @Override
    public void setChanged() {
        ItemStack stack = this.toStack();
        this.entityData.set(ITEM_STACK, (Object)stack, true);
        BlockPos pPos = this.blockPosition();
        this.level().updateNeighbourForOutputSignal(pPos, Blocks.AIR);
    }
}

