/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.network.serverbound.TraitMenuClick;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.bundle.BundleScreen;
import com.beansgalaxy.backpacks.traits.generic.ItemStorageTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class BundleLikeTraits
extends ItemStorageTraits {
    private final int size;

    public BundleLikeTraits(ModSound sound, int size) {
        super(sound);
        this.size = size;
    }

    public static Optional<BundleLikeTraits> get(ComponentHolder stack) {
        for (TraitComponentKind<? extends BundleLikeTraits> type : TraitComponentKind.BUNDLE_TRAITS) {
            BundleLikeTraits traits2 = stack.get(type);
            if (traits2 == null) continue;
            return Optional.of(traits2);
        }
        ReferenceTrait referenceTrait = stack.get(Traits.REFERENCE);
        if (referenceTrait != null) {
            return referenceTrait.getTrait().map(traits -> {
                if (traits instanceof BundleLikeTraits) {
                    BundleLikeTraits storageTraits = (BundleLikeTraits)traits;
                    return storageTraits;
                }
                return null;
            });
        }
        return Optional.empty();
    }

    public int size() {
        return this.size;
    }

    @Override
    public Fraction fullness(ComponentHolder holder) {
        List<ItemStack> stacks = holder.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return this.fullness(stacks);
    }

    public Fraction fullness(List<ItemStack> stacks) {
        return Traits.getWeight(stacks, this.size());
    }

    @Override
    public boolean isEmpty(ComponentHolder holder) {
        List<ItemStack> stacks = holder.get(ITraitData.ITEM_STACKS);
        return stacks == null || stacks.isEmpty();
    }

    @Override
    @Nullable
    public ItemStack getFirst(ComponentHolder holder) {
        List<ItemStack> stacks = holder.get(ITraitData.ITEM_STACKS);
        return stacks == null ? null : stacks.getFirst();
    }

    @Override
    public void stackedOnMe(ComponentHolder backpack, ItemStack other, Slot slot, ClickAction click, Player player, SlotAccess access, CallbackInfoReturnable<Boolean> cir) {
    }

    @Override
    public void stackedOnOther(ComponentHolder backpack, ItemStack other, Slot slot, ClickAction click, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (!ClickAction.SECONDARY.equals((Object)click)) {
            return;
        }
        MutableItemStorage mutable = this.mutable(backpack);
        ModSound sound = this.sound();
        if (other.isEmpty()) {
            ItemStack stack = ((MutableBundleLike)mutable).removeItem(other, player);
            if (stack.isEmpty() || !slot.mayPlace(stack)) {
                return;
            }
            slot.set(stack);
            sound.atClient(player, ModSound.Type.REMOVE);
        } else if (slot.mayPickup(player)) {
            if (((MutableBundleLike)mutable).addItem(other, 0) != null) {
                sound.atClient(player, ModSound.Type.INSERT);
            }
        } else {
            return;
        }
        mutable.push(cir);
    }

    @Override
    public boolean canItemFit(ComponentHolder holder, ItemStack inserted) {
        return !inserted.isEmpty() && super.canItemFit(holder, inserted);
    }

    @Override
    public abstract MutableBundleLike<?> mutable(ComponentHolder var1);

    @Override
    public void hotkeyUse(Slot slot, EquipmentSlot selectedEquipment, int button, ClickType actionType, Player player, CallbackInfo ci) {
        if (selectedEquipment == null) {
            ComponentHolder holder = ComponentHolder.of(slot.getItem());
            MutableItemStorage mutable = this.mutable(holder);
            if (((MutableBundleLike)mutable).isEmpty()) {
                ci.cancel();
                return;
            }
            Inventory inventory = player.getInventory();
            int selectedSlot = ((MutableBundleLike)mutable).getSelectedSlot(player);
            if (ClickType.PICKUP_ALL.equals((Object)actionType)) {
                List<ItemStack> stacks;
                ItemStack selectedStack;
                ItemStack carried = player.containerMenu.getCarried();
                if (!ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)(selectedStack = (stacks = ((MutableBundleLike)mutable).getItemStacks()).get(selectedSlot))) || !this.canItemFit(holder, carried)) {
                    ci.cancel();
                    return;
                }
                for (int i = stacks.size() - 1; i >= 0 && !mutable.isFull(); --i) {
                    ItemStack removed;
                    ItemStack stack = stacks.get(i);
                    boolean same = ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)stack);
                    if (!same) continue;
                    int stackableSlot = inventory.getSlotWithRemainingSpace(stack);
                    if (stackableSlot == -1) {
                        stackableSlot = inventory.getFreeSlot();
                    }
                    if (stackableSlot == -1 || !inventory.add(-1, removed = ((MutableBundleLike)mutable).removeItem(i))) continue;
                    ci.cancel();
                }
                boolean cancelled = ci.isCancelled();
                if (cancelled) {
                    this.sound().atClient(player, ModSound.Type.REMOVE);
                    ((MutableBundleLike)mutable).push();
                }
                return;
            }
            ItemStack stack = ((MutableBundleLike)mutable).removeItem(selectedSlot);
            int stackableSlot = inventory.getSlotWithRemainingSpace(stack);
            if (stackableSlot == -1) {
                stackableSlot = inventory.getFreeSlot();
            }
            if (stackableSlot != -1 && inventory.add(-1, stack)) {
                this.sound().atClient(player, ModSound.Type.REMOVE);
                ((MutableBundleLike)mutable).push();
                ci.cancel();
            }
        } else {
            ItemStack backpack = player.getItemBySlot(selectedEquipment);
            ComponentHolder holder = ComponentHolder.of(backpack);
            MutableItemStorage mutable = this.mutable(holder);
            if (mutable.isFull()) {
                return;
            }
            if (ClickType.PICKUP_ALL.equals((Object)actionType)) {
                List<ItemStack> stacks = ((MutableBundleLike)mutable).getItemStacks();
                ItemStack carried = player.containerMenu.getCarried();
                if (stacks.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)stacks.getFirst()) || !this.canItemFit(holder, carried)) {
                    ci.cancel();
                    return;
                }
                Inventory inventory = player.getInventory();
                NonNullList items = inventory.items;
                for (int i = items.size() - 1; i >= 0 && !mutable.isFull(); --i) {
                    ItemStack stack = (ItemStack)items.get(i);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)stack)) continue;
                    int toAdd = ((MutableBundleLike)mutable).getMaxAmountToAdd(stack.copy());
                    int count = Math.min(stack.getMaxStackSize(), toAdd);
                    ItemStack removed = stack.copyWithCount(count);
                    stack.shrink(count);
                    if (((MutableBundleLike)mutable).addItem(removed, 0) == null) continue;
                    ci.cancel();
                }
                boolean cancelled = ci.isCancelled();
                if (cancelled) {
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    ((MutableBundleLike)mutable).push();
                }
                return;
            }
            ItemStack stack = slot.getItem();
            if (this.canItemFit(holder, stack)) {
                ItemStack removed;
                int toAdd = ((MutableBundleLike)mutable).getMaxAmountToAdd(stack);
                if (slot instanceof ResultSlot) {
                    Optional optional = slot.tryRemove(stack.getCount(), toAdd, player);
                    if (optional.isEmpty()) {
                        return;
                    }
                    removed = (ItemStack)optional.get();
                    slot.onTake(player, removed);
                } else {
                    removed = slot.remove(toAdd);
                }
                if (((MutableBundleLike)mutable).addItem(removed, 0) != null) {
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    ((MutableBundleLike)mutable).push();
                    ci.cancel();
                }
            }
        }
    }

    @Override
    public void hotkeyThrow(Slot slot, ComponentHolder backpack, int button, Player player, boolean menuKeyDown, CallbackInfo ci) {
        if (this.isEmpty(backpack)) {
            return;
        }
        MutableItemStorage mutable = this.mutable(backpack);
        int selectedSlot = ((MutableBundleLike)mutable).getSelectedSlot(player);
        if (!menuKeyDown) {
            return;
        }
        ItemStack removed = ((MutableBundleLike)mutable).removeItem(selectedSlot);
        player.drop(removed, true);
        this.sound().atClient(player, ModSound.Type.REMOVE);
        ((MutableBundleLike)mutable).push();
        ci.cancel();
    }

    @Override
    public void breakTrait(ServerPlayer pPlayer, ItemStack instance) {
        List stacks = (List)instance.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return;
        }
        stacks.forEach(stack -> {
            boolean success = pPlayer.getInventory().add(-1, stack);
            if (!success || !stack.isEmpty()) {
                pPlayer.drop(stack, true, true);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BundleLikeTraits)) {
            return false;
        }
        BundleLikeTraits that = (BundleLikeTraits)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.size == that.size && Objects.equals((Object)this.sound(), (Object)that.sound());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sound(), this.size});
    }

    @Override
    public void tinyMenuClick(ComponentHolder holder, int index, TinyClickType clickType, SlotAccess carriedAccess, Player player) {
        List<ItemStack> stacks;
        int add;
        int size;
        ItemStack stack;
        MutableItemStorage mutable = this.mutable(holder);
        if (clickType.isHotbar()) {
            Inventory inventory = player.getInventory();
            ItemStack hotbarStack = (ItemStack)inventory.items.get(clickType.hotbarSlot);
            ItemStack stack2 = ((MutableBundleLike)mutable).removeItem(index);
            if (!hotbarStack.isEmpty()) {
                int add2 = ((MutableBundleLike)mutable).toAdd(hotbarStack);
                if (add2 < hotbarStack.getCount()) {
                    return;
                }
                ((MutableBundleLike)mutable).addItem(hotbarStack, index);
            }
            this.sound().at((Entity)player, ModSound.Type.REMOVE);
            inventory.items.set(clickType.hotbarSlot, (Object)stack2);
            ((MutableBundleLike)mutable).push();
            return;
        }
        if (clickType.isShift()) {
            ItemStack hotbar;
            Inventory inventory = player.getInventory();
            stack = ((MutableBundleLike)mutable).removeItem(index);
            size = inventory.items.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(hotbar = (ItemStack)inventory.items.get(i)))) {
                    add = Math.min(hotbar.getMaxStackSize() - hotbar.getCount(), stack.getCount());
                    hotbar.grow(add);
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (ItemStack)inventory.items.get(i)).isEmpty()) {
                    add = Math.min(stack.getMaxStackSize(), stack.getCount());
                    inventory.items.set(i, (Object)stack.copyWithCount(add));
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = ((MutableBundleLike)mutable).stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (arg_0, arg_1) -> this.lambda$tinyMenuClick$2(player, holder, stack, (MutableBundleLike)mutable, arg_0, arg_1));
        }
        if (clickType.isDrop()) {
            ItemStack stack3 = ((MutableBundleLike)mutable).removeItem(index);
            player.drop(stack3, true);
            ((MutableBundleLike)mutable).push();
            return;
        }
        stacks = ((MutableBundleLike)mutable).getItemStacks();
        ItemStack carried = carriedAccess.get();
        if (index == -1) {
            if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.copyWithCount(1)) != null) {
                    carried.shrink(1);
                    ((MutableBundleLike)mutable).push();
                    this.sound().at((Entity)player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried) != null) {
                ((MutableBundleLike)mutable).push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
            }
            return;
        }
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.copyWithCount(1), size) != null) {
                    carried.shrink(1);
                    ((MutableBundleLike)mutable).push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried, size) != null) {
                ((MutableBundleLike)mutable).push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        ItemStack stack4 = stacks.get(index);
        if (stack4.isEmpty() && carried.isEmpty()) {
            return;
        }
        if (!stack4.isEmpty() && !carried.isEmpty()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack4, (ItemStack)carried)) {
                int toAdd = ((MutableBundleLike)mutable).toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack4.grow(1);
                    carried.shrink(1);
                } else {
                    add = Math.min(stack4.getMaxStackSize() - stack4.getCount(), toAdd);
                    stack4.grow(add);
                    carried.shrink(add);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (((MutableBundleLike)mutable).addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = Mth.ceil((float)((float)stack4.getCount() / 2.0f));
            ItemStack split = stack4.split(count);
            carriedAccess.set(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.isEmpty()) {
            ItemStack removed = ((MutableBundleLike)mutable).removeItem(index);
            carriedAccess.set(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (((MutableBundleLike)mutable).addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        ((MutableBundleLike)mutable).push();
    }

    @Override
    public void tinyHotbarClick(ComponentHolder holder, int slotId, TinyClickType clickType, InventoryMenu menu, Player player) {
        if (TinyClickType.I_SHIFT.equals((Object)clickType)) {
            Slot slot = menu.getSlot(slotId);
            ItemStack hotbar = slot.getItem();
            MutableItemStorage mutable = this.mutable(holder);
            if (((MutableBundleLike)mutable).addItem(hotbar, ((MutableBundleLike)mutable).getItemStacks().size()) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                ((MutableBundleLike)mutable).push();
            }
            return;
        }
        super.tinyHotbarClick(holder, slotId, clickType, menu, player);
    }

    @Override
    public void onPlayerInteract(LivingEntity owner, Player player, ItemStack backpack, CallbackInfoReturnable<InteractionResult> cir) {
        if (player.level().isClientSide) {
            ViewableBackpack viewable = ViewableBackpack.get(owner);
            BundleScreen.openScreen(player, viewable, this);
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }

    @Override
    public void menuClick(ComponentHolder holder, int index, TraitMenuClick.Kind clickType, SlotAccess carriedAccess, Player player) {
        List<ItemStack> stacks;
        int size;
        ItemStack stack;
        MutableItemStorage mutable = this.mutable(holder);
        if (clickType.isShift()) {
            int add;
            ItemStack hotbar;
            Inventory inventory = player.getInventory();
            stack = ((MutableBundleLike)mutable).removeItem(index);
            size = inventory.items.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(hotbar = (ItemStack)inventory.items.get(i)))) {
                    add = Math.min(hotbar.getMaxStackSize() - hotbar.getCount(), stack.getCount());
                    hotbar.grow(add);
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (ItemStack)inventory.items.get(i)).isEmpty()) {
                    add = Math.min(stack.getMaxStackSize(), stack.getCount());
                    inventory.items.set(i, (Object)stack.copyWithCount(add));
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = ((MutableBundleLike)mutable).stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (arg_0, arg_1) -> this.lambda$menuClick$3(player, holder, stack, (MutableBundleLike)mutable, arg_0, arg_1));
        }
        if (clickType.isDrop()) {
            BackData backData = BackData.get(player);
            if (backData.isMenuKeyDown()) {
                stack = ((MutableBundleLike)mutable).removeItem(index);
            } else {
                ItemStack item = ((MutableBundleLike)mutable).getItemStacks().get(index);
                stack = item.copyWithCount(1);
                item.shrink(1);
            }
            player.drop(stack, true);
            ((MutableBundleLike)mutable).push();
            return;
        }
        stacks = ((MutableBundleLike)mutable).getItemStacks();
        ItemStack carried = carriedAccess.get();
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.copyWithCount(1), size) != null) {
                    carried.shrink(1);
                    ((MutableBundleLike)mutable).push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried, size) != null) {
                ((MutableBundleLike)mutable).push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        ItemStack stack2 = stacks.get(index);
        if (stack2.isEmpty() && carried.isEmpty()) {
            return;
        }
        if (!stack2.isEmpty() && !carried.isEmpty()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)carried)) {
                int toAdd = ((MutableBundleLike)mutable).toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack2.grow(1);
                    carried.shrink(1);
                } else {
                    stack2.grow(toAdd);
                    carried.shrink(toAdd);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.copyWithCount(1), index) != null) {
                    carried.shrink(1);
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = Mth.ceil((float)((float)Math.min(stack2.getMaxStackSize(), stack2.getCount()) / 2.0f));
            ItemStack split = stack2.split(count);
            carriedAccess.set(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.isEmpty()) {
            ItemStack removed = ((MutableBundleLike)mutable).removeItem(index);
            carriedAccess.set(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (((MutableBundleLike)mutable).addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        ((MutableBundleLike)mutable).push();
    }

    private /* synthetic */ boolean lambda$menuClick$3(Player player, ComponentHolder holder, ItemStack stack, MutableBundleLike mutable, BackpackTraits storageTraits, EquipmentSlot slot) {
        ItemStack backpack = player.getItemBySlot(slot);
        BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
        if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
            mutable.push();
            this.sound().atClient(player, ModSound.Type.INSERT);
            itemStorage.push();
        }
        return stack.isEmpty();
    }

    private /* synthetic */ boolean lambda$tinyMenuClick$2(Player player, ComponentHolder holder, ItemStack stack, MutableBundleLike mutable, BackpackTraits storageTraits, EquipmentSlot slot) {
        ItemStack backpack = player.getItemBySlot(slot);
        BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
        if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
            mutable.push();
            this.sound().atClient(player, ModSound.Type.INSERT);
            itemStorage.push();
        }
        return stack.isEmpty();
    }
}

