/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.network.serverbound.TraitMenuClick;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableChestLike;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class ChestLikeTraits
extends BundleLikeTraits {
    public ChestLikeTraits(ModSound sound, int size) {
        super(sound, size);
    }

    @Override
    public Fraction fullness(ComponentHolder holder) {
        List<ItemStack> stacks = holder.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return Fraction.getFraction((int)stacks.size(), (int)this.size());
    }

    @Override
    public boolean isFull(ComponentHolder holder) {
        List<ItemStack> stacks = holder.get(ITraitData.ITEM_STACKS);
        if (stacks == null || stacks.isEmpty() || stacks.size() < this.size()) {
            return false;
        }
        for (ItemStack stack : stacks) {
            int count;
            int maxStackSize = stack.getMaxStackSize();
            if (maxStackSize == (count = stack.getCount())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stackedOnOther(ComponentHolder backpack, ItemStack other, Slot slot, ClickAction click, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (!ClickAction.SECONDARY.equals((Object)click)) {
            return;
        }
        MutableBundleLike mutable = this.mutable(backpack);
        ModSound sound = this.sound();
        if (other.isEmpty()) {
            ItemStack stack = mutable.removeItem(other, player);
            if (stack.isEmpty() || !slot.mayPlace(stack)) {
                return;
            }
            slot.set(stack);
            sound.atClient(player, ModSound.Type.REMOVE);
        } else if (slot.mayPickup(player)) {
            if (mutable.addItem(other, 0) != null) {
                sound.atClient(player, ModSound.Type.INSERT);
            }
        } else {
            return;
        }
        mutable.push(cir);
    }

    @Override
    public boolean canItemFit(ComponentHolder holder, ItemStack inserted) {
        return !inserted.isEmpty() && super.canItemFit(holder, inserted);
    }

    @Override
    public abstract MutableChestLike<?> mutable(ComponentHolder var1);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChestLikeTraits)) {
            return false;
        }
        ChestLikeTraits that = (ChestLikeTraits)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.size() == that.size() && Objects.equals((Object)this.sound(), (Object)that.sound());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sound(), this.size()});
    }

    @Override
    public void tinyMenuClick(ComponentHolder holder, int index, TinyClickType clickType, SlotAccess carriedAccess, Player player) {
        List<ItemStack> stacks;
        int add;
        int size;
        ItemStack stack;
        MutableBundleLike mutable = this.mutable(holder);
        if (clickType.isHotbar()) {
            Inventory inventory = player.getInventory();
            ItemStack hotbarStack = (ItemStack)inventory.items.get(clickType.hotbarSlot);
            ItemStack stack2 = mutable.removeItem(index);
            if (!hotbarStack.isEmpty()) {
                int add2 = mutable.toAdd(hotbarStack);
                if (add2 < hotbarStack.getCount()) {
                    return;
                }
                mutable.addItem(hotbarStack, index);
            }
            this.sound().at((Entity)player, ModSound.Type.REMOVE);
            inventory.items.set(clickType.hotbarSlot, (Object)stack2);
            mutable.push();
            return;
        }
        if (clickType.isShift()) {
            ItemStack hotbar;
            Inventory inventory = player.getInventory();
            stack = mutable.removeItem(index);
            size = inventory.items.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(hotbar = (ItemStack)inventory.items.get(i)))) {
                    add = Math.min(hotbar.getMaxStackSize() - hotbar.getCount(), stack.getCount());
                    hotbar.grow(add);
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                mutable.push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (ItemStack)inventory.items.get(i)).isEmpty()) {
                    add = Math.min(stack.getMaxStackSize(), stack.getCount());
                    inventory.items.set(i, (Object)stack.copyWithCount(add));
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                mutable.push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = mutable.stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (storageTraits, slot) -> {
                ItemStack backpack = player.getItemBySlot(slot);
                BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
                if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    itemStorage.push();
                }
                return stack.isEmpty();
            });
        }
        if (clickType.isDrop()) {
            ItemStack stack3 = mutable.removeItem(index);
            player.drop(stack3, true);
            mutable.push();
            return;
        }
        stacks = mutable.getItemStacks();
        ItemStack carried = carriedAccess.get();
        if (index == -1) {
            if (clickType.isRight()) {
                if (mutable.addItem(carried.copyWithCount(1)) != null) {
                    carried.shrink(1);
                    mutable.push();
                    this.sound().at((Entity)player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried) != null) {
                mutable.push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
            }
            return;
        }
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (mutable.addItem(carried.copyWithCount(1), size) != null) {
                    carried.shrink(1);
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried, size) != null) {
                mutable.push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        ItemStack stack4 = stacks.get(index);
        if (stack4.isEmpty() && carried.isEmpty()) {
            return;
        }
        if (!stack4.isEmpty() && !carried.isEmpty()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack4, (ItemStack)carried)) {
                int toAdd = mutable.toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack4.grow(1);
                    carried.shrink(1);
                } else {
                    add = Math.min(stack4.getMaxStackSize() - stack4.getCount(), toAdd);
                    stack4.grow(add);
                    carried.shrink(add);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (mutable.addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = Mth.ceil((float)((float)stack4.getCount() / 2.0f));
            ItemStack split = stack4.split(count);
            carriedAccess.set(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.isEmpty()) {
            ItemStack removed = mutable.removeItem(index);
            carriedAccess.set(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (mutable.addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        mutable.push();
    }

    @Override
    public void tinyHotbarClick(ComponentHolder holder, int slotId, TinyClickType clickType, InventoryMenu menu, Player player) {
        if (TinyClickType.I_SHIFT.equals((Object)clickType)) {
            Slot slot = menu.getSlot(slotId);
            ItemStack hotbar = slot.getItem();
            MutableBundleLike mutable = this.mutable(holder);
            if (mutable.addItem(hotbar, mutable.getItemStacks().size()) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                mutable.push();
            }
            return;
        }
        super.tinyHotbarClick(holder, slotId, clickType, menu, player);
    }

    @Override
    public void onPlayerInteract(LivingEntity owner, Player player, ItemStack backpack, CallbackInfoReturnable<InteractionResult> cir) {
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }

    @Override
    public void menuClick(ComponentHolder holder, int index, TraitMenuClick.Kind clickType, SlotAccess carriedAccess, Player player) {
        List<ItemStack> stacks;
        int size;
        ItemStack stack;
        MutableBundleLike mutable = this.mutable(holder);
        if (clickType.isShift()) {
            int add;
            ItemStack hotbar;
            Inventory inventory = player.getInventory();
            stack = mutable.removeItem(index);
            size = inventory.items.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(hotbar = (ItemStack)inventory.items.get(i)))) {
                    add = Math.min(hotbar.getMaxStackSize() - hotbar.getCount(), stack.getCount());
                    hotbar.grow(add);
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                mutable.push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (ItemStack)inventory.items.get(i)).isEmpty()) {
                    add = Math.min(stack.getMaxStackSize(), stack.getCount());
                    inventory.items.set(i, (Object)stack.copyWithCount(add));
                    stack.shrink(add);
                }
                if (!stack.isEmpty()) continue;
                mutable.push();
                this.sound().at((Entity)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = mutable.stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (storageTraits, slot) -> {
                ItemStack backpack = player.getItemBySlot(slot);
                BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
                if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    itemStorage.push();
                }
                return stack.isEmpty();
            });
        }
        if (clickType.isDrop()) {
            BackData backData = BackData.get(player);
            if (backData.isMenuKeyDown()) {
                stack = mutable.removeItem(index);
            } else {
                ItemStack item = mutable.getItemStacks().get(index);
                stack = item.copyWithCount(1);
                item.shrink(1);
            }
            player.drop(stack, true);
            mutable.push();
            return;
        }
        stacks = mutable.getItemStacks();
        ItemStack carried = carriedAccess.get();
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (mutable.addItem(carried.copyWithCount(1), size) != null) {
                    carried.shrink(1);
                    mutable.push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried, size) != null) {
                mutable.push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        ItemStack stack2 = stacks.get(index);
        if (stack2.isEmpty() && carried.isEmpty()) {
            return;
        }
        if (!stack2.isEmpty() && !carried.isEmpty()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)carried)) {
                int toAdd = mutable.toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack2.grow(1);
                    carried.shrink(1);
                } else {
                    stack2.grow(toAdd);
                    carried.shrink(toAdd);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (clickType.isRight()) {
                if (mutable.addItem(carried.copyWithCount(1), index) != null) {
                    carried.shrink(1);
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (mutable.addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = Mth.ceil((float)((float)Math.min(stack2.getMaxStackSize(), stack2.getCount()) / 2.0f));
            ItemStack split = stack2.split(count);
            carriedAccess.set(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.isEmpty()) {
            ItemStack removed = mutable.removeItem(index);
            carriedAccess.set(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (mutable.addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        mutable.push();
    }
}

