/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.network.serverbound.TraitMenuClick;
import com.beansgalaxy.backpacks.traits.IClientTraits;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.generic.MutableTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class GenericTraits {
    private final ModSound sound;

    public GenericTraits(ModSound sound) {
        this.sound = sound;
    }

    public ModSound sound() {
        return this.sound;
    }

    public abstract String name();

    public abstract <T extends GenericTraits> IClientTraits<T> client();

    public abstract TraitComponentKind<? extends GenericTraits> kind();

    public abstract Fraction fullness(ComponentHolder var1);

    public Fraction fullness(ItemStack stack) {
        return this.fullness(ComponentHolder.of(stack));
    }

    public boolean isFull(ItemStack stack) {
        return this.isFull(ComponentHolder.of(stack));
    }

    public boolean isFull(ComponentHolder holder) {
        Fraction fullness = this.fullness(holder);
        int i = fullness.compareTo(Fraction.ONE);
        return i >= 0;
    }

    public boolean isEmpty(ItemStack stack) {
        return this.isEmpty(ComponentHolder.of(stack));
    }

    public abstract boolean isEmpty(ComponentHolder var1);

    public abstract void stackedOnMe(ComponentHolder var1, ItemStack var2, Slot var3, ClickAction var4, Player var5, SlotAccess var6, CallbackInfoReturnable<Boolean> var7);

    public abstract void stackedOnOther(ComponentHolder var1, ItemStack var2, Slot var3, ClickAction var4, Player var5, CallbackInfoReturnable<Boolean> var6);

    public void use(Level level, Player player, InteractionHand hand, ComponentHolder holder, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
    }

    public abstract MutableTraits mutable(ComponentHolder var1);

    public boolean isStackable(ComponentHolder holder) {
        return false;
    }

    public void onPlayerInteract(LivingEntity owner, Player player, ItemStack backpack, CallbackInfoReturnable<InteractionResult> cir) {
    }

    public void menuClick(ComponentHolder holder, int index, TraitMenuClick.Kind type, SlotAccess access, Player sender) {
    }
}

