/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.components.FilterComponent;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class ItemStorageTraits
extends GenericTraits {
    public ItemStorageTraits(ModSound sound) {
        super(sound);
    }

    public static Optional<ItemStorageTraits> get(DataComponentHolder stack) {
        for (TraitComponentKind<? extends ItemStorageTraits> type : TraitComponentKind.STORAGE_TRAITS) {
            ItemStorageTraits traits2 = (ItemStorageTraits)stack.get(type);
            if (traits2 == null) continue;
            return Optional.of(traits2);
        }
        ReferenceTrait referenceTrait = (ReferenceTrait)stack.get(Traits.REFERENCE);
        if (referenceTrait != null) {
            return referenceTrait.getTrait().map(traits -> {
                if (traits instanceof ItemStorageTraits) {
                    ItemStorageTraits storageTraits = (ItemStorageTraits)traits;
                    return storageTraits;
                }
                return null;
            });
        }
        return Optional.empty();
    }

    public static void runIfPresent(ItemStack stack, Consumer<ItemStorageTraits> runnable) {
        if (!stack.isEmpty()) {
            Optional<ItemStorageTraits> traits = ItemStorageTraits.get((DataComponentHolder)stack);
            traits.ifPresent(runnable);
        }
    }

    public static void runIfPresent(ItemStack stack, Consumer<ItemStorageTraits> runnable, Runnable orElse) {
        if (!stack.isEmpty()) {
            Optional<ItemStorageTraits> traits = ItemStorageTraits.get((DataComponentHolder)stack);
            traits.ifPresentOrElse(runnable, orElse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean tryMoveItems(MutableItemStorage to, ItemStack from, Player player) {
        MutableItemStorage other;
        if (to.isFull()) {
            return false;
        }
        Optional<ItemStorageTraits> optional = ItemStorageTraits.get((DataComponentHolder)from);
        if (optional.isEmpty()) {
            EnderTraits enderTraits = (EnderTraits)from.get(Traits.ENDER);
            if (enderTraits == null) {
                return false;
            }
            GenericTraits genericTraits = enderTraits.getTrait(player.level());
            if (!(genericTraits instanceof ItemStorageTraits)) return false;
            ItemStorageTraits traits = (ItemStorageTraits)genericTraits;
            other = traits.mutable(enderTraits);
        } else {
            other = optional.get().mutable(ComponentHolder.of(from));
        }
        if (other.isEmpty()) {
            return false;
        }
        other.moveItemsTo(to, player, true);
        return true;
    }

    @Override
    public abstract MutableItemStorage mutable(ComponentHolder var1);

    public abstract void hotkeyUse(Slot var1, EquipmentSlot var2, int var3, ClickType var4, Player var5, CallbackInfo var6);

    public abstract void hotkeyThrow(Slot var1, ComponentHolder var2, int var3, Player var4, boolean var5, CallbackInfo var6);

    public boolean overflowFromInventory(EquipmentSlot equipmentSlot, Player player, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        ItemStack backpack = player.getItemBySlot(equipmentSlot);
        MutableItemStorage mutable = this.mutable(ComponentHolder.of(backpack));
        ItemStack itemStack = mutable.addItem(stack);
        if (itemStack != null) {
            mutable.push();
            cir.setReturnValue((Object)true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                List<Pair> pSlots = List.of(Pair.of((Object)equipmentSlot, (Object)backpack));
                ClientboundSetEquipmentPacket packet = new ClientboundSetEquipmentPacket(serverPlayer.getId(), pSlots);
                serverPlayer.serverLevel().getChunkSource().broadcast((Entity)serverPlayer, (Packet)packet);
            }
            return itemStack.isEmpty();
        }
        return false;
    }

    public boolean canItemFit(ComponentHolder holder, ItemStack inserted) {
        FilterComponent component = FilterComponent.get(holder);
        if (component != null && !component.isEmpty() && !component.passes(inserted)) {
            return false;
        }
        return inserted.getItem().canFitInsideContainerItems() && Traits.get(inserted).isEmpty();
    }

    public abstract void breakTrait(ServerPlayer var1, ItemStack var2);

    @Nullable
    public abstract ItemStack getFirst(ComponentHolder var1);

    public void tinyHotbarClick(ComponentHolder holder, int slotId, TinyClickType clickType, InventoryMenu menu, Player player) {
        Slot slot = menu.getSlot(slotId);
        ItemStack hotbar = slot.getItem();
        if (ItemStorageTraits.tryMoveItems(this.mutable(holder), hotbar, player)) {
            return;
        }
        if (clickType.isAction()) {
            BackpackTraits.runIfEquipped(player, (storageTraits, equipment) -> {
                ItemStack backpack = player.getItemBySlot(equipment);
                BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
                if (this.canItemFit(ComponentHolder.of(backpack), hotbar) && itemStorage.addItem(hotbar) != null) {
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    itemStorage.push();
                }
                return hotbar.isEmpty();
            });
        }
        if (slot instanceof ResultSlot) {
            ResultSlot resultSlot = (ResultSlot)slot;
            if (!this.canItemFit(holder, hotbar)) {
                return;
            }
            MutableItemStorage mutable = this.mutable(holder);
            int toAdd = mutable.getMaxAmountToAdd(hotbar);
            Optional optional = resultSlot.tryRemove(hotbar.getCount(), toAdd, player);
            if (optional.isEmpty()) {
                return;
            }
            ItemStack removed = (ItemStack)optional.get();
            resultSlot.onTake(player, removed);
            if (mutable.addItem(removed) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                mutable.push();
            }
            return;
        }
        if (clickType.isShift()) {
            MutableItemStorage mutable = this.mutable(holder);
            if (mutable.addItem(hotbar) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                mutable.push();
            }
            return;
        }
        ItemStack carried = menu.getCarried();
        if (hotbar.isEmpty() && carried.isEmpty()) {
            return;
        }
        if (!hotbar.isEmpty() && !carried.isEmpty()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)hotbar, (ItemStack)carried)) {
                int count = clickType.isRight() ? 1 : carried.getCount();
                int toAdd = Math.min(hotbar.getMaxStackSize() - hotbar.getCount(), count);
                hotbar.grow(toAdd);
                carried.shrink(toAdd);
            } else {
                slot.set(carried);
                menu.setCarried(hotbar);
            }
        } else if (clickType.isRight()) {
            if (hotbar.isEmpty()) {
                ItemStack copy = carried.copyWithCount(1);
                carried.shrink(1);
                slot.set(copy);
            } else {
                int count = Mth.ceil((float)((float)hotbar.getCount() / 2.0f));
                ItemStack split = hotbar.split(count);
                menu.setCarried(split);
            }
        } else {
            slot.set(carried);
            menu.setCarried(hotbar);
        }
    }

    public abstract void tinyMenuClick(ComponentHolder var1, int var2, TinyClickType var3, SlotAccess var4, Player var5);
}

