/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class MutableBundleLike<T extends BundleLikeTraits>
implements MutableItemStorage {
    public final ITraitData<List<ItemStack>> stacks;
    protected final ComponentHolder holder;
    protected final T traits;

    public MutableBundleLike(T traits, ComponentHolder holder) {
        this.holder = holder;
        this.traits = traits;
        this.stacks = ITraitData.ITEM_STACKS.get(holder);
    }

    public List<ItemStack> getItemStacks() {
        return this.stacks.get();
    }

    @Override
    public ModSound sound() {
        return ((GenericTraits)this.traits).sound();
    }

    @Override
    public void push() {
        this.stacks.push();
        this.holder.setChanged();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public ItemStack removeItem(int slot) {
        if (slot < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack returned = ItemStack.EMPTY;
        List<ItemStack> stacks = this.getItemStacks();
        if (stacks.size() > slot) {
            ItemStack stack = stacks.get(slot);
            int maxCount = stack.getMaxStackSize();
            if (stack.getCount() > maxCount) {
                stack.shrink(maxCount);
                returned = stack.copyWithCount(maxCount);
            } else {
                returned = stacks.remove(slot);
                this.limitSelectedSlot(slot);
            }
        }
        return returned;
    }

    @Override
    public void moveItemsTo(MutableItemStorage to, Player player, boolean fullStack) {
        int selectedSlot = this.getSelectedSlot(player);
        ItemStack stack = this.getItemStacks().get(selectedSlot);
        int toAdd = to.getMaxAmountToAdd(stack);
        if (toAdd > 0) {
            ItemStack moved;
            if (!fullStack) {
                moved = stack.copyWithCount(1);
                stack.shrink(1);
            } else {
                int count = stack.getCount();
                if (count < toAdd) {
                    int min = Math.min(count, toAdd);
                    moved = stack.copyWithCount(min);
                    stack.shrink(min);
                } else {
                    moved = this.removeItem(selectedSlot);
                }
            }
            to.addItem(moved);
            this.push();
            to.push();
            this.sound().at((Entity)player, ModSound.Type.REMOVE);
        }
    }

    @Override
    public ItemStack addItem(ItemStack inserted) {
        if (!((BundleLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.getCount(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<ItemStack> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            ItemStack stored = stacks.get(--i);
            if (inserted.isEmpty() || toInsert < 1) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stored, (ItemStack)inserted)) continue;
            stored.grow(toInsert);
            inserted.shrink(toInsert);
            return ItemStack.EMPTY;
        }
        if (!inserted.isEmpty()) {
            ItemStack split = inserted.split(toInsert);
            this.getItemStacks().addFirst(split);
            this.growSelectedSlot(0);
        }
        return inserted;
    }

    public ItemStack addItem(ItemStack inserted, int slot) {
        if (!((BundleLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.getCount(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<ItemStack> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            ItemStack stored = stacks.get(--i);
            if (inserted.isEmpty() || toInsert < 1) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stored, (ItemStack)inserted)) continue;
            ItemStack removed = stacks.remove(i);
            int size = stacks.size();
            stacks.add(Math.min(slot, size), removed);
            removed.grow(toInsert);
            inserted.shrink(toInsert);
            return ItemStack.EMPTY;
        }
        if (!inserted.isEmpty()) {
            int selectedSlot = Math.min(slot, this.getItemStacks().size());
            ItemStack split = inserted.split(toInsert);
            this.getItemStacks().add(selectedSlot, split);
            this.growSelectedSlot(selectedSlot);
        }
        return inserted;
    }

    @Override
    public int getMaxAmountToAdd(ItemStack stack) {
        Fraction size = Fraction.getFraction((int)((BundleLikeTraits)this.traits).size(), (int)1);
        Fraction weight = Traits.getWeight(this.getItemStacks());
        Fraction weightLeft = size.subtract(weight);
        return Math.max(weightLeft.divideBy(Traits.getItemWeight(stack)).intValue(), 0);
    }

    public ItemStack removeItem(ItemStack other, Player player) {
        return this.removeItem(0);
    }

    public int getSelectedSlot(Player player) {
        return 0;
    }

    public void growSelectedSlot(int slot) {
    }

    @Override
    public Fraction fullness() {
        List<ItemStack> stacks = this.stacks.get();
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return Traits.getWeight(stacks, ((BundleLikeTraits)this.traits).size());
    }

    public int toAdd(ItemStack carried) {
        if (!((BundleLikeTraits)this.traits).canItemFit(this.holder, carried)) {
            return 0;
        }
        int spaceLeft = this.getMaxAmountToAdd(carried);
        return Math.min(carried.getCount(), spaceLeft);
    }

    public void limitSelectedSlot(int index) {
    }
}

