/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.traits.generic.ChestLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class MutableChestLike<T extends ChestLikeTraits>
extends MutableBundleLike<T> {
    public MutableChestLike(T traits, ComponentHolder holder) {
        super(traits, holder);
    }

    @Override
    public List<ItemStack> getItemStacks() {
        return (List)this.stacks.get();
    }

    @Override
    public ModSound sound() {
        return ((ChestLikeTraits)this.traits).sound();
    }

    @Override
    public void push() {
        this.stacks.push();
        this.holder.setChanged();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    public ItemStack removeItem(int slot) {
        if (slot < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack returned = ItemStack.EMPTY;
        List<ItemStack> stacks = this.getItemStacks();
        if (stacks.size() > slot) {
            ItemStack stack = stacks.get(slot);
            int maxCount = stack.getMaxStackSize();
            if (stack.getCount() > maxCount) {
                stack.shrink(maxCount);
                returned = stack.copyWithCount(maxCount);
            } else {
                returned = stacks.remove(slot);
                this.limitSelectedSlot(slot);
            }
        }
        return returned;
    }

    @Override
    public void moveItemsTo(MutableItemStorage to, Player player, boolean fullStack) {
        int selectedSlot = this.getSelectedSlot(player);
        ItemStack stack = this.getItemStacks().get(selectedSlot);
        int toAdd = to.getMaxAmountToAdd(stack);
        if (toAdd > 0) {
            ItemStack moved;
            if (!fullStack) {
                moved = stack.copyWithCount(1);
                stack.shrink(1);
            } else {
                int count = stack.getCount();
                if (count < toAdd) {
                    moved = stack.copyWithCount(count);
                    stack.shrink(count);
                } else {
                    moved = this.removeItem(selectedSlot);
                }
            }
            to.addItem(moved);
            this.push();
            to.push();
            this.sound().at((Entity)player, ModSound.Type.REMOVE);
        }
    }

    @Override
    public ItemStack addItem(ItemStack inserted) {
        if (!((ChestLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.getCount(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<ItemStack> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            ItemStack stored = stacks.get(--i);
            if (inserted.isEmpty() || toInsert < 1) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stored, (ItemStack)inserted)) continue;
            int count = Math.min(toInsert, stored.getMaxStackSize() - stored.getCount());
            stored.grow(count);
            inserted.shrink(count);
            toInsert -= count;
        }
        if (!inserted.isEmpty()) {
            ItemStack split = inserted.split(toInsert);
            this.getItemStacks().addFirst(split);
            this.growSelectedSlot(0);
        }
        return inserted;
    }

    @Override
    public ItemStack addItem(ItemStack inserted, int slot) {
        if (!((ChestLikeTraits)this.traits).canItemFit(this.holder, inserted)) {
            return null;
        }
        int spaceLeft = this.getMaxAmountToAdd(inserted);
        int toInsert = Math.min(inserted.getCount(), spaceLeft);
        if (toInsert == 0) {
            return null;
        }
        List<ItemStack> stacks = this.getItemStacks();
        int i = stacks.size();
        while (i > 0) {
            int maxStackSize;
            ItemStack stored = stacks.get(--i);
            if (inserted.isEmpty() || toInsert < 1) {
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stored, (ItemStack)inserted)) continue;
            int totalCount = stored.getCount() + toInsert;
            if (totalCount > (maxStackSize = stored.getMaxStackSize())) {
                int count = totalCount - maxStackSize;
                ItemStack removed = stored.copyWithCount(count);
                stored.setCount(maxStackSize);
                int selectedSlot = Math.min(slot, stacks.size());
                stacks.add(selectedSlot, removed);
                inserted.shrink(toInsert);
                this.growSelectedSlot(selectedSlot);
                continue;
            }
            ItemStack removed = stacks.remove(i);
            int size = stacks.size();
            stacks.add(Math.min(slot, size), removed);
            removed.grow(toInsert);
            inserted.shrink(toInsert);
        }
        if (!inserted.isEmpty()) {
            int selectedSlot = Math.min(slot, this.getItemStacks().size());
            ItemStack split = inserted.split(toInsert);
            this.getItemStacks().add(selectedSlot, split);
            this.growSelectedSlot(selectedSlot);
        }
        return inserted;
    }

    @Override
    public int getMaxAmountToAdd(ItemStack inserted) {
        List<ItemStack> stacks = this.getItemStacks();
        int remainingStacks = ((ChestLikeTraits)this.traits).size() - stacks.size();
        if (remainingStacks > 0) {
            return inserted.getMaxStackSize() * remainingStacks;
        }
        int toAdd = 0;
        for (ItemStack stored : stacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stored, (ItemStack)inserted)) continue;
            toAdd += inserted.getMaxStackSize() - inserted.getCount();
        }
        return toAdd;
    }

    @Override
    public ItemStack removeItem(ItemStack other, Player player) {
        return this.removeItem(0);
    }

    @Override
    public int getSelectedSlot(Player player) {
        return 0;
    }

    @Override
    public void growSelectedSlot(int slot) {
    }

    @Override
    public Fraction fullness() {
        List stacks = (List)this.stacks.get();
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return Fraction.getFraction((int)stacks.size(), (int)((ChestLikeTraits)this.traits).size());
    }
}

